package com.tacz.guns.client.particle;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.particles.BulletHoleOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_707;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

/**
 * Author: Forked from MrCrayfish, continued by Timeless devs
 */
public class BulletHoleParticle extends class_4003 {
    private final class_2350 direction;
    private final class_2338 pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(class_638 world, double x, double y, double z, class_2350 direction, class_2338 pos, String ammoId, String gunId, String gunDisplayId) {
        super(world, x, y, z);
        this.method_18141(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.field_3847 = this.getLifetimeFromConfig(world);
        this.field_3862 = false;
        this.field_3844 = 0.0F;
        this.field_17867 = 0.05F;

        class_2680 state = world.method_8320(pos);
        if (state.method_27852(ModBlocks.TARGET) || shouldRemove()) {
            this.method_3085();
        }
        TimelessAPI.getGunDisplay(class_2960.method_60654(gunDisplayId), class_2960.method_60654(gunId)).ifPresent(gunIndex -> {
            float[] gunTracerColor = gunIndex.getTracerColor();
            if (gunTracerColor != null) {
                this.field_3861 = gunTracerColor[0];
                this.field_3842 = gunTracerColor[1];
                this.field_3859 = gunTracerColor[2];
            } else {
                TimelessAPI.getClientAmmoIndex(class_2960.method_60654(ammoId)).ifPresent(ammoIndex -> {
                    float[] ammoTracerColor = ammoIndex.getTracerColor();
                    this.field_3861 = ammoTracerColor[0];
                    this.field_3842 = ammoTracerColor[1];
                    this.field_3859 = ammoTracerColor[2];
                });
            }
        });
        this.field_3841 = 0.9F;
    }

    private int getLifetimeFromConfig(class_638 world) {
        int configLife = RenderConfig.BULLET_HOLE_PARTICLE_LIFE.get();
        if (configLife <= 1) {
            return configLife;
        }
        return configLife + world.field_9229.method_43048(configLife / 2);
    }

    @Override
    protected void method_18141(class_1058 sprite) {
        super.method_18141(sprite);
        this.uOffset = this.field_3840.method_43048(16);
        this.vOffset = this.field_3840.method_43048(16);
        // 材质应该都是方形
        this.textureDensity = (sprite.method_4577() - sprite.method_4594()) / 16.0F;
    }

    private class_1058 getSprite(class_2338 pos) {
        class_310 minecraft = class_310.method_1551();
        class_1937 world = minecraft.field_1687;
        if (world != null) {
            class_2680 state = world.method_8320(pos);
            // return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getTexture(state, world, pos);
            return class_310.method_1551().method_1541().method_3351().method_3339(state);
        }
        return class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
    }

    @Override
    protected float method_18133() {
        return this.field_17886.method_4594() + this.uOffset * this.textureDensity;
    }

    @Override
    protected float method_18135() {
        return this.field_17886.method_4593() + this.vOffset * this.textureDensity;
    }

    @Override
    protected float method_18134() {
        return this.method_18133() + this.textureDensity;
    }

    @Override
    protected float method_18136() {
        return this.method_18135() + this.textureDensity;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (shouldRemove()) {
            this.method_3085();
        }
    }

    @Override
    public void method_3074(class_4588 buffer, class_4184 renderInfo, float partialTicks) {
        class_243 view = renderInfo.method_19326();
        float particleX = (float) (class_3532.method_16436(partialTicks, this.field_3858, this.field_3874) - view.method_10216());
        float particleY = (float) (class_3532.method_16436(partialTicks, this.field_3838, this.field_3854) - view.method_10214());
        float particleZ = (float) (class_3532.method_16436(partialTicks, this.field_3856, this.field_3871) - view.method_10215());
        Quaternionf quaternion = this.direction.method_23224();
        Vector3f[] points = new Vector3f[]{
                // Y 值稍微大一点点，防止 z-fight
                new Vector3f(-1.0F, 0.01F, -1.0F),
                new Vector3f(-1.0F, 0.01F, 1.0F),
                new Vector3f(1.0F, 0.01F, 1.0F),
                new Vector3f(1.0F, 0.01F, -1.0F)
        };
        float scale = this.method_18132(partialTicks);

        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.rotate(quaternion);
            vector3f.mul(scale);
            vector3f.add(particleX, particleY, particleZ);
        }

        // UV 坐标
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();

        // 0 - 30 tick 内，从 15 亮度到 0 亮度
        int light = Math.max(15 - this.field_3866 / 2, 0);
        int lightColor = class_765.method_23687(light, light);

        // 颜色，逐渐渐变到 0 0 0，也就是黑色
        float colorPercent = light / 15.0f;
        float red = this.field_3861 * colorPercent;
        float green = this.field_3842 * colorPercent;
        float blue = this.field_3859 * colorPercent;

        // 透明度，逐渐变成 0，也就是透明
        double threshold = RenderConfig.BULLET_HOLE_PARTICLE_FADE_THRESHOLD.get() * this.field_3847;
        float fade = 1.0f - (float) (Math.max(this.field_3866 - threshold, 0) / (this.field_3847 - threshold));
        float alphaFade = this.field_3841 * fade;

        buffer.method_22912(points[0].x(), points[0].y(), points[0].z()).method_22913(u1, v1).method_22915(red, green, blue, alphaFade).method_60803(lightColor);
        buffer.method_22912(points[1].x(), points[1].y(), points[1].z()).method_22913(u1, v0).method_22915(red, green, blue, alphaFade).method_60803(lightColor);
        buffer.method_22912(points[2].x(), points[2].y(), points[2].z()).method_22913(u0, v0).method_22915(red, green, blue, alphaFade).method_60803(lightColor);
        buffer.method_22912(points[3].x(), points[3].y(), points[3].z()).method_22913(u0, v1).method_22915(red, green, blue, alphaFade).method_60803(lightColor);
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17827;
    }

    private boolean shouldRemove() {
        final class_2680 blockState = this.field_3851.method_8320(this.pos);
        if (blockState.method_26215()) {
            return true;
        } else {
            // 阻止弹孔在与方块不构成有效附着时继续渲染
            class_265 shape = blockState.method_26220(this.field_3851, this.pos);
            if (shape.method_1110()) {
                return true;
            }
            class_238 baseBlockBoundingBox = shape.method_1107();
            class_238 blockBoundingBox = baseBlockBoundingBox.method_996(this.pos);
            boolean intersects = blockBoundingBox.method_1003(
                    this.field_3874 - 0.1, this.field_3854 - 0.1, this.field_3871 - 0.1,
                    this.field_3874 + 0.1, this.field_3854 + 0.1, this.field_3871 + 0.1);
            return !intersects;
        }
    }

    @Environment(EnvType.CLIENT)
    public static class Provider implements class_707<BulletHoleOption> {
        public Provider() {
        }

        @Override
        public BulletHoleParticle createParticle(@NotNull BulletHoleOption option, @NotNull class_638 world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
            BulletHoleParticle particle = new BulletHoleParticle(world, x, y, z, option.getDirection(), option.getPos(), option.getAmmoId(), option.getGunId(), option.getGunDisplayId());
            return particle;
        }
    }
}
