package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.manager.SoundAssetsManager.SoundData;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4228;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import javax.sound.sampled.AudioFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SoundAssetsManager extends class_4080<Map<class_2960, SoundData>> implements IdentifiableResourceReloadListener {
    public record SoundData(ByteBuffer byteBuffer, AudioFormat audioFormat) {
    }

    private static final Marker MARKER = MarkerFactory.getMarker("SoundsLoader");

    private final Map<class_2960, SoundData> dataMap = Maps.newHashMap();
    private final class_7654 filetoidconverter = new class_7654("tacz_sounds", ".ogg");

    @Override
    @NotNull
    protected Map<class_2960, SoundData> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        Map<class_2960, SoundData> output = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(pResourceManager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            try (InputStream stream = entry.getValue().method_14482(); class_4228 audioStream = new class_4228(stream)) {
                ByteBuffer bytebuffer = audioStream.method_59757();
                output.put(resourcelocation1, new SoundData(bytebuffer, audioStream.method_19719()));
            } catch (IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read sound file: {}", resourcelocation);
                exception.printStackTrace();
            }
        }
        return output;
    }

    @Override
    protected void apply(Map<class_2960, SoundData> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        dataMap.clear();
        dataMap.putAll(pObject);
    }

    public SoundData getData(class_2960 id) {
        return dataMap.get(id);
    }

    public static final class_2960 ID = class_2960.method_60655(GunMod.MOD_ID, "sound_assets_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
