package com.tacz.guns.entity.shooter;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.event.common.GunFireSelectEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFireSelect;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public class LivingEntityFireSelect {
    private final class_1309 shooter;
    private final ShooterDataHolder data;

    public LivingEntityFireSelect(class_1309 shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void fireSelect() {
        if (data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = data.currentGunItem.get();
        if (!(currentGunItem.method_7909() instanceof IGun iGun)) {
            return;
        }
        GunFireSelectEvent fireSelectEvent = new GunFireSelectEvent(shooter, currentGunItem, LogicalSide.SERVER);
        GunFireSelectEvent.CALLBACK.invoker().post(fireSelectEvent);
        if (fireSelectEvent.isCanceled()) {
            return;
        }
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunFireSelect(shooter.method_5628(), currentGunItem), shooter);
        if (iGun instanceof AbstractGunItem logicGun) {
            logicGun.fireSelect(data, currentGunItem);
            // 刷新配件缓存
            AttachmentPropertyManager.postChangeEvent(shooter, currentGunItem);
        }
    }
}
