package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.vmlib.LuaLibrary;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.*;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ScriptManager extends class_4080<List<Map.Entry<String, Supplier<LuaTable>>>> implements IdentifiableResourceReloadListener {
    private static final Marker MARKER = MarkerFactory.getMarker("ScriptLoader");
    private Globals globals;
    private final Map<String, LuaTable> scriptMap = Maps.newHashMap();
    private final class_7654 filetoidconverter;
    private final List<LuaLibrary> libraries;

    public ScriptManager(class_7654 converter, List<LuaLibrary> libraries) {
        this.filetoidconverter = converter;
        this.libraries = libraries;
    }

    @Override
    @NotNull
    protected List<Map.Entry<String, Supplier<LuaTable>>> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        // 初始化 globals
        initGlobals();
        // 打包加载函数，设置 globals 的 preload
        List<Map.Entry<String, Supplier<LuaTable>>> output = new ArrayList<>();
        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(pResourceManager).entrySet()) {
            var wrappedEntry = wrapLoadingFunction(entry.getKey(), entry.getValue());
            output.add(wrappedEntry);
            globals.get("package").get("preload").set(wrappedEntry.getKey(), new LuaFunction() {
                @Override
                public LuaValue call(LuaValue modname, LuaValue env) {
                    return wrappedEntry.getValue().get();
                }
            });
        }
        return output;
    }

    @Override
    protected void apply(List<Map.Entry<String, Supplier<LuaTable>>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        scriptMap.clear();
        pObject.forEach(entry -> scriptMap.put(entry.getKey(), entry.getValue().get()));
    }

    private Map.Entry<String, Supplier<LuaTable>> wrapLoadingFunction(class_2960 rawResourceLocation, class_3298 resource) {
        class_2960 resourceLocation = filetoidconverter.method_45115(rawResourceLocation);
        String moduleName = getModuleName(resourceLocation);
        return new AbstractMap.SimpleEntry<>(moduleName, new Supplier<>() {
            private LuaTable loaded = null;

            @Override
            public LuaTable get() {
                if (loaded != null) {
                    return loaded;
                }
                try (Reader reader = resource.method_43039()) {
                    LuaValue chunk = globals.load(reader, moduleName);
                    loaded = chunk.call().checktable(1);
                    return loaded;
                } catch (IllegalArgumentException | IOException | JsonParseException | LuaError jsonparseexception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read script file: {}", resourceLocation);
                }
                return null;
            }
        });
    }

    private void initGlobals() {
        globals = JsePlatform.standardGlobals();
        //LuaJC.install(globals);
        if (libraries != null) {
            libraries.forEach(library -> library.install(globals));
        }
    }

    private String getModuleName(class_2960 resourceLocation) {
        return resourceLocation.method_12836() + "_" + resourceLocation.method_12832();
    }

    public LuaTable getScript(class_2960 id) {
        return scriptMap.get(getModuleName(id));
    }

    public static final class_2960 ID = class_2960.method_60655(GunMod.MOD_ID, "script_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
