/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.api.vmlib.LuaAnimationConstant;
import com.tacz.guns.api.vmlib.LuaGunAnimationConstant;
import com.tacz.guns.api.vmlib.LuaLibrary;
import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.client.resource.manager.DisplayManager;
import com.tacz.guns.client.resource.manager.GltfManager;
import com.tacz.guns.client.resource.manager.PackInfoManager;
import com.tacz.guns.client.resource.manager.SoundAssetsManager;
import com.tacz.guns.client.resource.pojo.CommonTransformObject;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.animation.bedrock.AnimationKeyframes;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.animation.bedrock.SoundEffectKeyframes;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.tacz.guns.client.resource.pojo.display.block.BlockDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.CubesItem;
import com.tacz.guns.client.resource.serialize.AnimationKeyframesSerializer;
import com.tacz.guns.client.resource.serialize.ItemStackSerializer;
import com.tacz.guns.client.resource.serialize.SoundEffectKeyframesSerializer;
import com.tacz.guns.client.resource.serialize.Vector3fSerializer;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.manager.JsonDataManager;
import com.tacz.guns.resource.manager.ScriptManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7654;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.luaj.vm2.LuaTable;

@Environment(value=EnvType.CLIENT)
public enum ClientAssetsManager {
    INSTANCE;

    public static final Gson GSON;
    private JsonDataManager<GunDisplay> gunDisplay;
    private JsonDataManager<AmmoDisplay> ammoDisplay;
    private JsonDataManager<AttachmentDisplay> attachmentDisplay;
    private JsonDataManager<BlockDisplay> blockDisplay;
    private JsonDataManager<BedrockModelPOJO> bedrockModel;
    private JsonDataManager<BedrockAnimationFile> bedrockAnimation;
    private GltfManager gltfAnimation;
    private final List<LuaLibrary> libList = List.of(new LuaAnimationConstant(), new LuaGunAnimationConstant());
    private ScriptManager scriptManager;
    private SoundAssetsManager soundAssetsManager;
    private PackInfoManager packInfo;
    private List<IdentifiableResourceReloadListener> listeners;

    public void reloadAndRegister(Consumer<IdentifiableResourceReloadListener> register) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IdentifiableResourceReloadListener>();
            this.gunDisplay = this.register(new DisplayManager<GunDisplay>(GunDisplay.class, GSON, "display/guns", "GunDisplayLoader"));
            this.ammoDisplay = this.register(new DisplayManager<AmmoDisplay>(AmmoDisplay.class, GSON, "display/ammo", "AmmoDisplayLoader"));
            this.attachmentDisplay = this.register(new DisplayManager<AttachmentDisplay>(AttachmentDisplay.class, GSON, "display/attachments", "AttachmentDisplayLoader"));
            this.blockDisplay = this.register(new DisplayManager<BlockDisplay>(BlockDisplay.class, GSON, "display/blocks", "BlockDisplayLoader"));
            this.bedrockModel = this.register(new JsonDataManager<BedrockModelPOJO>(BedrockModelPOJO.class, GSON, "geo_models", "BedrockModelLoader"));
            this.bedrockAnimation = this.register(new JsonDataManager<BedrockAnimationFile>(BedrockAnimationFile.class, GSON, new class_7654("animations", ".animation.json"), "BedrockAnimationLoader"));
            this.gltfAnimation = this.register(new GltfManager());
            this.scriptManager = this.register(new ScriptManager(new class_7654("scripts", ".lua"), this.libList));
            this.soundAssetsManager = this.register(new SoundAssetsManager());
            this.packInfo = this.register(new PackInfoManager());
        }
        this.listeners.forEach(register);
    }

    private <T extends IdentifiableResourceReloadListener> T register(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    @Nullable
    public GunDisplay getGunDisplay(class_2960 id) {
        return this.gunDisplay.getData(id);
    }

    public Set<Map.Entry<class_2960, GunDisplay>> getGunDisplays() {
        return this.gunDisplay.getAllData().entrySet();
    }

    @Nullable
    public AttachmentDisplay getAttachmentDisplay(class_2960 id) {
        return this.attachmentDisplay.getData(id);
    }

    @Nullable
    public AmmoDisplay getAmmoDisplay(class_2960 id) {
        return this.ammoDisplay.getData(id);
    }

    @Nullable
    public BlockDisplay getBlockDisplay(class_2960 id) {
        return this.blockDisplay.getData(id);
    }

    @Nullable
    public BedrockModelPOJO getBedrockModelPOJO(class_2960 id) {
        return this.bedrockModel.getData(id);
    }

    @Nullable
    public BedrockAnimationFile getBedrockAnimations(class_2960 id) {
        return this.bedrockAnimation.getData(id);
    }

    @Nullable
    public LuaTable getScript(class_2960 id) {
        return this.scriptManager.getScript(id);
    }

    @Nullable
    public AnimationStructure getGltfAnimation(class_2960 id) {
        return this.gltfAnimation.getGltfAnimation(id);
    }

    @Nullable
    public SoundAssetsManager.SoundData getSoundBuffers(class_2960 id) {
        return this.soundAssetsManager.getData(id);
    }

    @Nullable
    public PackInfo getPackInfo(String namespace) {
        return this.packInfo.getData(namespace);
    }

    @Nullable
    public PackInfo getPackInfo(@Nullable class_2960 namespace) {
        if (namespace == null) {
            return null;
        }
        return this.packInfo.getData(namespace.method_12836());
    }

    @Environment(value=EnvType.CLIENT)
    public static void reloadAllPack() {
        try {
            class_310.method_1551().method_1521().get();
            if (class_310.method_1551().method_1576() == null) {
                ClientIndexManager.reload();
            } else {
                CommonAssetsManager.reloadAllPack((MinecraftServer)class_310.method_1551().method_1576());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fSerializer()).registerTypeAdapter(CommonTransformObject.class, (Object)new CommonTransformObject.Serializer()).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).registerTypeAdapter(AnimationKeyframes.class, (Object)new AnimationKeyframesSerializer()).registerTypeAdapter(SoundEffectKeyframes.class, (Object)new SoundEffectKeyframesSerializer()).registerTypeAdapter(class_809.class, (Object)new class_809.class_810()).registerTypeAdapter(class_804.class, (Object)new class_804.class_805()).create();
    }
}

