/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.ICommonResourceProvider;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;

public enum CommonNetworkCache implements ICommonResourceProvider
{
    INSTANCE;

    public Map<class_2960, GunData> gunData = new HashMap<class_2960, GunData>();
    public Map<class_2960, AttachmentData> attachmentData = new HashMap<class_2960, AttachmentData>();
    public Map<class_2960, RecipeFilter> recipeFilter = new HashMap<class_2960, RecipeFilter>();
    public Map<class_2960, BlockData> blockData = new HashMap<class_2960, BlockData>();
    public Map<class_2960, CommonGunIndex> gunIndex = new HashMap<class_2960, CommonGunIndex>();
    public Map<class_2960, CommonAmmoIndex> ammoIndex = new HashMap<class_2960, CommonAmmoIndex>();
    public Map<class_2960, CommonAttachmentIndex> attachmentIndex = new HashMap<class_2960, CommonAttachmentIndex>();
    public Map<class_2960, CommonBlockIndex> blockIndex = new HashMap<class_2960, CommonBlockIndex>();
    public Map<class_2960, Set<String>> attachmentTags = new HashMap<class_2960, Set<String>>();
    public Map<class_2960, Set<String>> allowAttachmentTags = new HashMap<class_2960, Set<String>>();

    @Override
    @Nullable
    public GunData getGunData(class_2960 id) {
        return this.gunData.get(id);
    }

    @Override
    @Nullable
    public AttachmentData getAttachmentData(class_2960 attachmentId) {
        return this.attachmentData.get(attachmentId);
    }

    @Override
    @Nullable
    public BlockData getBlockData(class_2960 id) {
        return this.blockData.get(id);
    }

    @Override
    @Nullable
    public RecipeFilter getRecipeFilter(class_2960 id) {
        return this.recipeFilter.get(id);
    }

    @Override
    @Nullable
    public CommonGunIndex getGunIndex(class_2960 id) {
        return this.gunIndex.get(id);
    }

    @Override
    @Nullable
    public CommonAmmoIndex getAmmoIndex(class_2960 ammoId) {
        return this.ammoIndex.get(ammoId);
    }

    @Override
    @Nullable
    public CommonAttachmentIndex getAttachmentIndex(class_2960 attachmentId) {
        return this.attachmentIndex.get(attachmentId);
    }

    @Override
    @Nullable
    public CommonBlockIndex getBlockIndex(class_2960 blockId) {
        return this.blockIndex.get(blockId);
    }

    @Override
    @Nullable
    public LuaTable getScript(class_2960 scriptId) {
        return null;
    }

    @Override
    public Set<Map.Entry<class_2960, CommonGunIndex>> getAllGuns() {
        return this.gunIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<class_2960, CommonAmmoIndex>> getAllAmmos() {
        return this.ammoIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<class_2960, CommonAttachmentIndex>> getAllAttachments() {
        return this.attachmentIndex.entrySet();
    }

    @Override
    public Set<Map.Entry<class_2960, CommonBlockIndex>> getAllBlocks() {
        return this.blockIndex.entrySet();
    }

    @Override
    public Set<String> getAttachmentTags(class_2960 registryName) {
        return this.attachmentTags.get(registryName);
    }

    @Override
    public Set<String> getAllowAttachmentTags(class_2960 registryName) {
        return this.allowAttachmentTags.get(registryName);
    }

    public void fromNetwork(Map<DataType, Map<class_2960, String>> cache) {
        this.gunData.clear();
        this.attachmentData.clear();
        this.gunIndex.clear();
        this.ammoIndex.clear();
        this.attachmentIndex.clear();
        this.blockIndex.clear();
        this.recipeFilter.clear();
        this.blockData.clear();
        this.attachmentTags.clear();
        this.allowAttachmentTags.clear();
        HashMap<DataType, Map<class_2960, String>> delayed = new HashMap<DataType, Map<class_2960, String>>();
        block3: for (Map.Entry<DataType, Map<class_2960, String>> entry : cache.entrySet()) {
            switch (entry.getKey()) {
                case GUN_INDEX: 
                case AMMO_INDEX: 
                case ATTACHMENT_INDEX: 
                case BLOCK_INDEX: {
                    delayed.put(entry.getKey(), entry.getValue());
                    continue block3;
                }
            }
            this.fromNetwork(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<DataType, Map<Object, String>> entry : delayed.entrySet()) {
            this.fromNetwork(entry.getKey(), entry.getValue());
        }
    }

    private <T> T parse(String json, Class<T> dataClass) {
        return (T)CommonAssetsManager.GSON.fromJson(json, dataClass);
    }

    private AttachmentData parseAttachmentData(String json) {
        AttachmentData data = (AttachmentData)CommonAssetsManager.GSON.fromJson(json, AttachmentData.class);
        JsonElement element = (JsonElement)CommonAssetsManager.GSON.fromJson(json, JsonElement.class);
        if (data != null) {
            AttachmentPropertyManager.getModifiers().forEach((key, value) -> {
                if (!element.isJsonObject()) {
                    return;
                }
                JsonObject jsonObject = element.getAsJsonObject();
                if (jsonObject.has(key)) {
                    JsonProperty property = value.readJson(json);
                    property.initComponents();
                    data.addModifier((String)key, property);
                } else if (jsonObject.has(value.getOptionalFields())) {
                    JsonProperty property = value.readJson(json);
                    property.initComponents();
                    data.addModifier((String)key, property);
                }
            });
        }
        return data;
    }

    private void resolveAttachmentTags(Map<class_2960, String> data) {
        for (Map.Entry<class_2960, String> entry : data.entrySet()) {
            List tags = (List)CommonAssetsManager.GSON.fromJson(entry.getValue(), (TypeToken)new TypeToken<List<String>>(this){});
            if (entry.getKey().method_12832().startsWith("allow_attachments/") && entry.getKey().method_12832().length() > 18) {
                class_2960 gunId = entry.getKey().method_45136(entry.getKey().method_12832().substring(18));
                this.allowAttachmentTags.computeIfAbsent(gunId, v -> new HashSet()).addAll(tags);
                continue;
            }
            this.attachmentTags.computeIfAbsent(entry.getKey(), v -> new HashSet()).addAll(tags);
        }
    }

    private void fromNetwork(DataType type, Map<class_2960, String> data) {
        for (Map.Entry<class_2960, String> entry : data.entrySet()) {
            try {
                switch (type) {
                    case GUN_DATA: {
                        this.gunData.put(entry.getKey(), this.parse(entry.getValue(), GunData.class));
                        break;
                    }
                    case GUN_INDEX: {
                        this.gunIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonGunIndex.class));
                        break;
                    }
                    case AMMO_INDEX: {
                        this.ammoIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonAmmoIndex.class));
                        break;
                    }
                    case ATTACHMENT_DATA: {
                        this.attachmentData.put(entry.getKey(), this.parseAttachmentData(entry.getValue()));
                        break;
                    }
                    case ATTACHMENT_INDEX: {
                        this.attachmentIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonAttachmentIndex.class));
                        break;
                    }
                    case ATTACHMENT_TAGS: {
                        this.resolveAttachmentTags(data);
                        break;
                    }
                    case BLOCK_INDEX: {
                        this.blockIndex.put(entry.getKey(), this.parse(entry.getValue(), CommonBlockIndex.class));
                        break;
                    }
                    case RECIPE_FILTER: {
                        this.recipeFilter.put(entry.getKey(), this.parse(entry.getValue(), RecipeFilter.class));
                        break;
                    }
                    case BLOCK_DATA: {
                        this.blockData.put(entry.getKey(), this.parse(entry.getValue(), BlockData.class));
                    }
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                GunMod.LOGGER.warn("Failed to parse data from network for {} with id {}", new Object[]{type, entry.getKey(), exception});
            }
        }
    }
}

