/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.crafting.result.RawGunTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class GunSmithTableResultSerializer
implements JsonDeserializer<GunSmithTableResult> {
    public GunSmithTableResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            GunSmithTableResult result;
            JsonObject jsonObject = json.getAsJsonObject();
            String typeName = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
            int count = 1;
            class_2487 extraTag = null;
            class_2960 tabOverride = null;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260((JsonObject)jsonObject, (String)"count"), 1);
            }
            if (jsonObject.has("nbt")) {
                extraTag = (class_2487)class_2487.field_25128.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("nbt")).getOrThrow();
            }
            if (jsonObject.has("group")) {
                Object raw = class_3518.method_15265((JsonObject)jsonObject, (String)"group");
                if (!((String)raw).contains(":")) {
                    raw = "tacz:" + (String)raw;
                }
                tabOverride = class_2960.method_12829((String)raw);
            }
            switch (typeName) {
                case "gun": 
                case "ammo": 
                case "attachment": {
                    GunResult gunResult;
                    RawGunTableResult raw = new RawGunTableResult(typeName, this.getId(jsonObject), count);
                    if (extraTag != null) {
                        raw.setNbt(extraTag);
                    }
                    if (typeName.equals("gun") && (gunResult = (GunResult)CommonAssetsManager.GSON.fromJson((JsonElement)jsonObject, GunResult.class)) != null) {
                        raw.setExtraData(gunResult);
                    }
                    result = new GunSmithTableResult(raw, tabOverride);
                    break;
                }
                case "custom": {
                    JsonObject resultObject = class_3518.method_15296((JsonObject)jsonObject, (String)"item");
                    class_1799 itemStack = (class_1799)class_1799.field_24671.parse((DynamicOps)JsonOps.INSTANCE, (Object)resultObject).getOrThrow();
                    result = new GunSmithTableResult(itemStack, tabOverride);
                    break;
                }
                default: {
                    return new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
                }
            }
            return result;
        }
        return new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
    }

    private class_2960 getId(JsonObject jsonObject) {
        return class_2960.method_60654((String)class_3518.method_15265((JsonObject)jsonObject, (String)"id"));
    }
}

