package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * 生物开始更换枪械弹药时触发的事件。
 */
public class GunDrawEvent extends BaseEvent implements KubeJSGunEventPoster<GunDrawEvent> {
    private final class_1309 entity;
    private final class_1799 previousGunItem;
    private final class_1799 currentGunItem;
    private final LogicalSide logicalSide;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(GunDrawEvent event);
    }

    public GunDrawEvent(class_1309 entity, class_1799 previousGunItem, class_1799 currentGunItem, LogicalSide side) {
        this.entity = entity;
        this.previousGunItem = previousGunItem;
        this.currentGunItem = currentGunItem;
        this.logicalSide = side;
        postEventToKubeJS(this);
    }

    public class_1309 getEntity() {
        return entity;
    }

    public class_1799 getPreviousGunItem() {
        return previousGunItem;
    }

    public class_1799 getCurrentGunItem() {
        return currentGunItem;
    }

    public LogicalSide getLogicalSide() {
        return logicalSide;
    }
}
