package com.tacz.guns.api.item;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

/**
 * 这里不包含枪械的逻辑，只包含枪械的各种 nbt 访问。<br>
 * 你可以在 {@link AbstractGunItem} 看到枪械逻辑
 */
public interface IGun {
    /**
     * @return 如果物品类型为 IGun 则返回显式转换后的实例，否则返回 null。
     */
    @Nullable
    static IGun getIGunOrNull(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        if (stack.method_7909() instanceof IGun iGun) {
            return iGun;
        }
        return null;
    }

    /**
     * 是否主手持枪
     */
    @Deprecated
    static boolean mainhandHoldGun(class_1309 livingEntity) {
        return livingEntity.method_6047().method_7909() instanceof IGun;
    }

    /**
     * 是否主手持枪
     */
    static boolean mainHandHoldGun(class_1309 livingEntity) {
        return livingEntity.method_6047().method_7909() instanceof IGun;
    }

    /**
     * 获取主手枪械的开火模式
     */
    @Deprecated
    static FireMode getMainhandFireMode(class_1309 livingEntity) {
        class_1799 mainHandItem = livingEntity.method_6047();
        if (mainHandItem.method_7909() instanceof IGun iGun) {
            return iGun.getFireMode(mainHandItem);
        }
        return FireMode.UNKNOWN;
    }

    /**
     * 获取主手枪械的开火模式
     */
    static FireMode getMainHandFireMode(class_1309 livingEntity) {
        class_1799 mainHandItem = livingEntity.method_6047();
        if (mainHandItem.method_7909() instanceof IGun iGun) {
            return iGun.getFireMode(mainHandItem);
        }
        return FireMode.UNKNOWN;
    }

    /**
     * 获取瞄准放大倍率
     */
    float getAimingZoom(class_1799 gunItem);

    /**
     * 枪械换弹时是否使用"虚拟备弹"而不是背包里的实际弹药
     */
    boolean useDummyAmmo(class_1799 gun);

    /**
     * 获取枪械当前的"虚拟备弹"数量
     */
    int getDummyAmmoAmount(class_1799 gun);

    /**
     * 设置枪械当前的"虚拟备弹"数量
     */
    void setDummyAmmoAmount(class_1799 gun, int amount);

    /**
     * 添加枪械当前的"虚拟备弹"数量
     */
    void addDummyAmmoAmount(class_1799 gun, int amount);

    /**
     * 检查是否有设置"虚拟备弹"最大数量
     */
    boolean hasMaxDummyAmmo(class_1799 gun);

    /**
     * 获取枪械当前的"虚拟备弹"最大数量
     */
    int getMaxDummyAmmoAmount(class_1799 gun);

    /**
     * 设置枪械当前的"虚拟备弹"最大数量
     */
    void setMaxDummyAmmoAmount(class_1799 gun, int amount);

    /**
     * 获取枪械的"配件锁"情况
     */
    boolean hasAttachmentLock(class_1799 gun);

    /**
     * 设置枪械的"配件锁"
     */
    void setAttachmentLock(class_1799 gun, boolean locked);

    /**
     * 获取枪械 ID
     */
    @NotNull
    class_2960 getGunId(class_1799 gun);

    /**
     * 设置枪械 ID
     */
    void setGunId(class_1799 gun, @Nullable class_2960 gunId);

    /**
     * 获取枪械客户端效果 ID, 如果是默认皮肤将返回 {@link DefaultAssets#DEFAULT_GUN_DISPLAY_ID}<br/>
     * 你应该使用 {@link com.tacz.guns.api.TimelessAPI#getGunDisplay(class_1799)} 获取正确的客户端效果
     */
    @NotNull
    class_2960 getGunDisplayId(class_1799 gun);

    /**
     * 设置枪械客户端效果 ID
     */
    void setGunDisplayId(class_1799 gun, @Nullable class_2960 displayId);

    /**
     * 获取输入的经验值对应的等级。
     *
     * @param exp 经验值
     * @return 对应的等级
     */
    int getLevel(int exp);

    /**
     * 获取输入的等级需要至少多少的经验值。
     *
     * @param level 等级
     * @return 至少需要的经验值
     */
    int getExp(int level);

    /**
     * 返回允许的最大等级。
     *
     * @return 最大等级
     */
    int getMaxLevel();

    /**
     * 获取枪械当前等级
     */
    int getLevel(class_1799 gun);

    /**
     * 获取积累的全部经验值。
     *
     * @param gun 输入物品
     * @return 全部经验值
     */
    int getExp(class_1799 gun);

    /**
     * 获取到下个等级需要的经验值。
     *
     * @param gun 输入物品
     * @return 到下个等级需要的经验值。如果等级已经到达最大，则返回 0
     */
    int getExpToNextLevel(class_1799 gun);

    /**
     * 获取当前等级已经积累的经验值。
     *
     * @param gun 输入物品
     * @return 当前等级已经积累的经验值
     */
    int getExpCurrentLevel(class_1799 gun);

    /**
     * 获取开火模式
     *
     * @param gun 枪
     * @return 开火模式
     */
    FireMode getFireMode(class_1799 gun);

    /**
     * 设置开火模式
     */
    void setFireMode(class_1799 gun, @Nullable FireMode fireMode);

    /**
     * 获取当前枪械弹药数
     */
    int getCurrentAmmoCount(class_1799 gun);

    /**
     * 设置当前枪械弹药数
     */
    void setCurrentAmmoCount(class_1799 gun, int ammoCount);

    /**
     * 减少一个当前枪械弹药数
     */
    void reduceCurrentAmmoCount(class_1799 gun);

    /**
     * 动态修改枪械的属性。
     * 注意：对于某些复杂属性来说，{@code GunProperty} 的类型可能会和值的类型不一样。
     * 比如伤害和精准度这样的复杂属性，GunProperty 的类型是复杂的数据结构，传入和返回的值就只是简单的浮点数。
     *
     * @param dataHolder 状态数据
     * @param gunItem    枪械物品
     * @param shooter    射击者
     * @param id         属性 id，请参阅 {@link com.tacz.guns.api.GunProperties}
     * @param type       属性的数据类型
     * @param original   属性原来的值
     * @param <T>        属性的数据类型
     * @return 脚本或子类修改后的属性
     * @author ChloePrime
     * @since 1.1.7
     */
    default <T> T modifyProperty(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter,
                                 GunProperty<?> id, Class<T> type, T original) {
        return modifyProperty(dataHolder, gunItem, shooter, id.name(), type, original);
    }

    /**
     * 动态修改枪械的属性
     *
     * @param dataHolder 状态数据
     * @param gunItem    枪械物品
     * @param shooter    射击者
     * @param id         属性 id，请参阅 {@link com.tacz.guns.api.GunProperties}
     * @param type       属性的数据类型
     * @param original   属性原来的值
     * @param <T>        属性的数据类型
     * @return 脚本或子类修改后的属性
     * @author ChloePrime
     * @since 1.1.7
     */
    default <T> T modifyProperty(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter,
                                 String id, Class<T> type, T original) {
        return modifyProperty(dataHolder, gunItem, shooter, "modify_property", id, type, original);
    }

    /**
     * 动态修改枪械的属性，
     * 允许指定修改用的 lua 函数的名称
     *
     * @param dataHolder    状态数据
     * @param gunItem       枪械物品
     * @param shooter       射击者
     * @param luaMethodName 修改属性的 lua 函数的函数名
     * @param id            属性 id，请参阅 {@link com.tacz.guns.api.GunProperties}
     * @param type          属性的数据类型
     * @param original      属性原来的值
     * @param <T>           属性的数据类型
     * @return 脚本或子类修改后的属性
     * @author ChloePrime
     * @since 1.1.7
     */
    default <T> T modifyProperty(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter,
                                 String luaMethodName, String id, Class<T> type, T original) {
        return original;
    }

    /**
     * 取下枪内所有子弹。玩家的特殊方法，默认卸载弹药时使用
     */
    void dropAllAmmo(class_1657 player, class_1799 gun);

    /**
     * 获取当前枪械指定类型的配件
     */
    @Nonnull
    class_1799 getAttachment(class_1799 gun, AttachmentType type);

    @Nonnull
    class_1799 getBuiltinAttachment(class_1799 gun, AttachmentType type);

    /**
     * 获取当前枪械指定类型的配件的 NBT 数据
     *
     * @return 如果为空，那么没有配件数据
     */
    @Nullable
    class_2487 getAttachmentTag(class_1799 gun, AttachmentType type);

    @Nonnull
    class_2960 getBuiltInAttachmentId(class_1799 gun, AttachmentType type);

    /**
     * 获取枪械的配件 ID
     * <p>
     * 如果不存在，返回 {@link DefaultAssets#EMPTY_ATTACHMENT_ID};
     */
    @Nonnull
    class_2960 getAttachmentId(class_1799 gun, AttachmentType type);

    /**
     * 安装配件
     */
    void installAttachment(@Nonnull class_1799 gun, @Nonnull class_1799 attachment);

    /**
     * 卸载配件
     */
    void unloadAttachment(@Nonnull class_1799 gun, AttachmentType type);

    /**
     * 该枪械是否允许装配该配件
     */
    boolean allowAttachment(class_1799 gun, class_1799 attachmentItem);

    /**
     * 该枪械是否允许某类型配件
     */
    boolean allowAttachmentType(class_1799 gun, AttachmentType type);

    /**
     * 枪管中是否有子弹，用于闭膛待击的枪械
     */
    boolean hasBulletInBarrel(class_1799 gun);

    /**
     * 设置枪管中的子弹有无，用于闭膛待击的枪械
     */
    void setBulletInBarrel(class_1799 gun, boolean bulletInBarrel);

    /**
     * 枪械是否为备弹直读
     */
    boolean useInventoryAmmo(class_1799 gun);

    /**
     * 获取枪械是否有备弹 (只针对背包直读读的机制使用)
     */
    boolean hasInventoryAmmo(class_1309 shooter, class_1799 gun, boolean needCheckAmmo);

    /**
     * 获取 RPM
     */
    int getRPM(class_1799 gun);

    /**
     * 获取是否可以趴下
     */
    boolean isCanCrawl(class_1799 gun);

    boolean hasCustomLaserColor(class_1799 gun);

    int getLaserColor(class_1799 gun);

    void setLaserColor(class_1799 gun, int color);

    /**
     * Heat Data
     */
    boolean hasHeatData(class_1799 gun);

    /**
     * 是否完全过热
     */
    boolean isOverheatLocked(class_1799 gun);

    void setOverheatLocked(class_1799 gun, boolean locked);

    /**
     * 设置当前过热值
     */
    void setHeatAmount(class_1799 gun, float amount);

    float lerpRPM(class_1799 gun);

    float lerpInaccuracy(class_1799 gun);

    float getHeatAmount(class_1799 gun);
}