package com.tacz.guns.api.util;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;

/**
 * 一个简单的NBT包装，用于在Lua中访问NBT数据。<br/>
 * 暂时只支持基本数据类型的读写，不支持数组等复杂数据类型。
 */
@SuppressWarnings("unused")
public record LuaNbtAccessor(class_2487 nbt) {

    public static LuaNbtAccessor from(class_1799 stack) {
        return new LuaNbtAccessor(stack.method_7969());
    }

    public static LuaNbtAccessor from(class_2487 nbt) {
        return new LuaNbtAccessor(nbt);
    }

    public boolean contains(String key) {
        return nbt.method_10545(key);
    }

    public boolean contains(String key, int type) {
        return nbt.method_10573(key, type);
    }

    public LuaNbtAccessor newCompoundTag() {
        return new LuaNbtAccessor(new class_2487());
    }

    public int getInt(String key) {
        return nbt.method_10550(key);
    }

    public double getDouble(String key) {
        return nbt.method_10574(key);
    }

    public float getFloat(String key) {
        return nbt.method_10583(key);
    }

    public long getLong(String key) {
        return nbt.method_10537(key);
    }

    public String getString(String key) {
        return nbt.method_10558(key);
    }

    public boolean getBoolean(class_2487 nbt, String key) {
        return nbt.method_10577(key);
    }

    public LuaNbtAccessor getCompound(String key) {
        if (!nbt.method_10573(key, class_2520.field_33260)) {
            return null;
        }
        return from(nbt.method_10562(key));
    }

    public void putInt(String key, int value) {
        nbt.method_10569(key, value);
    }

    public void putDouble(String key, double value) {
        nbt.method_10549(key, value);
    }

    public void putFloat(String key, float value) {
        nbt.method_10548(key, value);
    }

    public void putLong(String key, long value) {
        nbt.method_10544(key, value);
    }

    public void putString(String key, String value) {
        nbt.method_10582(key, value);
    }

    public void putBoolean(String key, boolean value) {
        nbt.method_10556(key, value);
    }

    /**
     * 向当前的NbtCompound中添加一个新的Compound
     *
     * @param key   键
     * @param value 在脚本中请使用{@link LuaNbtAccessor#newCompoundTag()}创建一个新的LuaNbtAccessor对象
     */
    public void putCompound(String key, LuaNbtAccessor value) {
        if (value != null) {
            nbt.method_10566(key, value.nbt());
        }
    }

    @Override
    @ApiStatus.Internal
    public class_2487 nbt() {
        return nbt;
    }
}
