package com.tacz.guns.client.particle;


import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.tacz.guns.entity.EntityKineticBullet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.joml.Vector3f;

@Environment(EnvType.CLIENT)
public class AmmoParticleSpawner {
    public static void addParticle(EntityKineticBullet bullet) {
        TimelessAPI.getGunDisplay(bullet.getGunDisplayId(), bullet.getGunId()).ifPresent(gunIndex -> {
            AmmoParticle gunParticle = gunIndex.getParticle();
            if (gunParticle == null) {
                // 如果枪械没有粒子效果，那么调用子弹的
                TimelessAPI.getClientAmmoIndex(bullet.getAmmoId()).ifPresent(ammoIndex -> {
                    AmmoParticle ammoParticle = ammoIndex.getParticle();
                    if (ammoParticle == null) {
                        return;
                    }
                    spawnParticle(bullet, ammoParticle);
                });
            } else {
                // 否则调用调用枪械的
                spawnParticle(bullet, gunParticle);
            }
        });
    }

    private static void spawnParticle(EntityKineticBullet bullet, AmmoParticle particle) {
        class_2394 particleOptions = particle.getParticleOptions();
        if (particleOptions == null) {
            return;
        }
        int count = particle.getCount();
        Vector3f delta = particle.getDelta();
        float particleSpeed = particle.getSpeed();
        class_702 particleEngine = class_310.method_1551().field_1713;
        if (count == 0) {
            double xSpeed = particleSpeed * delta.x();
            double ySpeed = particleSpeed * delta.y();
            double zSpeed = particleSpeed * delta.z();
            class_703 result = particleEngine.method_3056(particleOptions, bullet.method_23317(), bullet.method_23318(), bullet.method_23321(), xSpeed, ySpeed, zSpeed);
            if (result != null) {
                result.method_3077(particle.getLifeTime());
            }
        } else {
            class_5819 random = bullet.getRandom();
            class_1297 owner = bullet.method_24921();
            for (int i = 0; i < count; ++i) {
                createParticle(bullet, particle, random, delta, particleSpeed, owner, particleEngine, particleOptions);
            }
        }
    }

    private static void createParticle(EntityKineticBullet bullet, AmmoParticle particle, class_5819 random, Vector3f delta, float particleSpeed, class_1297 owner, class_702 particleEngine, class_2394 particleOptions) {
        class_243 deltaMovement = bullet.method_18798();
        double deltaMovementRandom = random.method_43058();
        double offsetX = random.method_43059() * delta.x() + deltaMovementRandom * deltaMovement.field_1352;
        double offsetY = random.method_43059() * delta.y() + deltaMovementRandom * deltaMovement.field_1351;
        double offsetZ = random.method_43059() * delta.z() + deltaMovementRandom * deltaMovement.field_1350;
        double xSpeed = random.method_43059() * particleSpeed;
        double ySpeed = random.method_43059() * particleSpeed;
        double zSpeed = random.method_43059() * particleSpeed;

        double posX = bullet.method_23317() + offsetX;
        double posY = bullet.method_23318() + offsetY;
        double posZ = bullet.method_23321() + offsetZ;

        // 如果太贴近发射者，不进行粒子生成
        if (owner == null || owner.method_5649(posX, posY, posZ) > 3 * 3) {
            class_703 result = particleEngine.method_3056(particleOptions, posX, posY, posZ, xSpeed, ySpeed, zSpeed);
            if (result != null) {
                result.method_3077(particle.getLifeTime());
            }
        }
    }
}
