package com.tacz.guns.client.renderer.item;

import cn.sh1rocu.tacz.api.event.ViewportEvent;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.client.animation.statemachine.GunAnimationConstant;
import com.tacz.guns.client.animation.statemachine.ItemAnimationStateContext;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.util.math.MathUtil;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import java.util.List;

/**
 * 抽象的基岩版动画物品模型BEWLR，包含一些默认实现
 *
 * @param <M>   基岩版模型
 * @param <CTX> 动画状态机上下文
 */
public abstract class AnimateGeoItemRenderer<M extends BedrockAnimatedModel, CTX extends ItemAnimationStateContext>
        extends class_756 {
    @Nullable
    protected LuaAnimationStateMachine<CTX> stateMachine;
    protected M model;
    public class_2960 textureLocation;

    public AnimateGeoItemRenderer() {
        super(class_310.method_1551().method_31975(), class_310.method_1551().method_31974());
    }

    public void setModel(M model) {
        this.model = model;
    }

    public M getModel(class_1799 stack) {
        return model;
    }

    @Nullable
    public LuaAnimationStateMachine<CTX> getStateMachine(class_1799 stack) {
        return stateMachine;
    }

    public class_2960 getTextureLocation(class_1799 stack) {
        return textureLocation;
    }

    public class_1921 getRenderType(class_1799 stack) {
        return class_1921.method_23576(getTextureLocation(stack));
    }

    public boolean needReInit(class_1799 stack) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return false;
        }
        return !stateMachine.isInitialized() && stateMachine.getExitingTime() < System.currentTimeMillis();
    }

    public abstract CTX initContext(class_1799 stack, class_1657 player, float partialTick);

    public abstract void updateContext(CTX context, class_1799 stack, class_1657 player, float partialTick);

    /**
     * 计算并返回切出动画的时长，单位ms
     *
     * @return 保持时间
     */
    public long getPutAwayTime(class_1799 stack) {
        return 0;
    }

    /**
     * 尝试初始化状态机并触发切入信号
     */
    public void tryInit(class_1799 stack, class_1657 player, float partialTick) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        if (stateMachine.isInitialized()) {
            stateMachine.exit();
        }

        stateMachine.setContext(initContext(stack, player, partialTick));
        stateMachine.initialize();

        stateMachine.trigger(GunAnimationConstant.INPUT_DRAW);
    }

    /**
     * 尝试退出状态机并触发切出信号
     */
    public void tryExit(class_1799 stack, long putAwayTime) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> {
            context.setPutAwayTime(putAwayTime / 1000F);
        });
        if (stateMachine.isInitialized()) {
            stateMachine.trigger(GunAnimationConstant.INPUT_PUT_AWAY);
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            // 需要设置的比动画稍长些，避免意外的重初始化（可能是丢精度了）
            // 延后一tick应该基本没有感知）
            stateMachine.setExitingTime(putAwayTime + 50);
        }
    }

    /**
     * 尝试触发状态机转移
     *
     * @param input 输入信号
     */
    public void triggerAnimation(class_1799 stack, String input) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.trigger(input);
    }

    /**
     * 更新状态机但是不进行模型写入，用于播放音效
     */
    public void visualUpdate(class_1799 stack) {
        var stateMachine = getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.visualUpdate();
    }

    /**
     * 应用状态机的世界摄像机动画，暂时只用于玩家
     */
    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, class_746 player) {
        this.applyLevelCameraAnimation(event, stack, 1);
    }

    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, float multiplier) {
        var model = getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf q = MathUtil.multiplyQuaternion(model.getCameraAnimationObject().rotationQuaternion, multiplier);
        double yaw = Math.asin(2 * (q.w() * q.y() - q.x() * q.z()));
        double pitch = Math.atan2(2 * (q.w() * q.x() + q.y() * q.z()), 1 - 2 * (q.x() * q.x() + q.y() * q.y()));
        double roll = Math.atan2(2 * (q.w() * q.z() + q.x() * q.y()), 1 - 2 * (q.y() * q.y() + q.z() * q.z()));
        yaw = Math.toDegrees(yaw);
        pitch = Math.toDegrees(pitch);
        roll = Math.toDegrees(roll);
        event.setYaw((float) yaw + event.getYaw());
        event.setPitch((float) pitch + event.getPitch());
        event.setRoll((float) roll + event.getRoll());
    }

    /**
     * 应用状态机的手持物品摄像机动画，暂时只用于玩家
     */
    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, class_746 player) {
        applyItemInHandCameraAnimation(event, stack, 1);
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, float multiplier) {
        var model = getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf quaternion = MathUtil.multiplyQuaternion(model.getCameraAnimationObject().rotationQuaternion, multiplier);
        class_4587 poseStack = event.getPoseStack();
        poseStack.method_22907(quaternion);
    }

    /**
     * 执行额外的变换
     */
    public void doExtraTransforms(class_4587 poseStack, M model, class_1799 stack) {
        applyFirstPersonPositioningTransform(poseStack, model, stack);
    }

    /**
     * 渲染第一人称，暂时只用于玩家，入口参见 {@link com.tacz.guns.client.event.FirstPersonRenderEvent}
     */
    public void renderFirstPerson(class_746 player, class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource,
                                  int light, float partialTick) {
        M model = getModel(stack);
        if (model != null) {
            poseStack.method_22903();
            float xRotOffset = class_3532.method_16439(partialTick, player.field_3914, player.field_3916);
            float yRotOffset = class_3532.method_16439(partialTick, player.field_3931, player.field_3932);
            float xRot = player.method_5695(partialTick) - xRotOffset;
            float yRot = player.method_5705(partialTick) - yRotOffset;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xRot * -0.1F));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot * -0.1F));
            BedrockPart rootNode = model.getRootNode();
            if (rootNode != null) {
                xRot = (float) Math.tanh(xRot / 25) * 25;
                yRot = (float) Math.tanh(yRot / 25) * 25;
                rootNode.offsetX += yRot * 0.1F / 16F / 3F;
                rootNode.offsetY += -xRot * 0.1F / 16F / 3F;
                rootNode.additionalQuaternion.mul(class_7833.field_40714.rotationDegrees(xRot * 0.05F));
                rootNode.additionalQuaternion.mul(class_7833.field_40716.rotationDegrees(yRot * 0.05F));
            }

            // 从渲染原点 (0, 24, 0) 移动到模型原点 (0, 0, 0)
            poseStack.method_46416(0, 1.5f, 0);
            // 基岩版模型是上下颠倒的，需要翻转过来。
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
            doExtraTransforms(poseStack, model, stack);

            var stateMachine = getStateMachine(stack);
            if (stateMachine != null) {
                stateMachine.processContextIfExist(context -> {
                    updateContext(context, stack, player, partialTick);
                });
                stateMachine.update();
            }

            model.render(poseStack, ctx, getRenderType(stack), light, class_4608.field_21444);

            // 渲染结束后清除动画变换
            model.cleanAnimationTransform();
            poseStack.method_22909();
        }
    }

    @ParametersAreNonnullByDefault
    @Override
    public void method_3166(class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource,
                             int light, int overlay) {
        if (ctx.method_29998()) return;
        M model = getModel(stack);
        if (model != null) {
            poseStack.method_22903();
            // 从渲染原点 (0, 24, 0) 移动到模型原点 (0, 0, 0)
            poseStack.method_22904(0.5, 1.5f, 0.5);
            // 基岩版模型是上下颠倒的，需要翻转过来。
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
            model.render(poseStack, ctx, class_1921.method_23576(
                    getTextureLocation(stack)
            ), light, overlay);
            poseStack.method_22909();
        }
    }

    /**
     * 获取摄像机定位组的反相矩阵
     */
    @Nonnull
    public static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; i--) {
                BedrockPart part = nodePath.get(i);
                // 计算反向的旋转
                matrix4f.rotate(class_7833.field_40713.rotation(part.xRot));
                matrix4f.rotate(class_7833.field_40715.rotation(part.yRot));
                matrix4f.rotate(class_7833.field_40717.rotation(part.zRot));
                // 计算反向的位移
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0F, -part.y / 16.0F, -part.z / 16.0F);
                } else {
                    matrix4f.translate(-part.x / 16.0F, (1.5F - part.y / 16.0F), -part.z / 16.0F);
                }
            }
        }
        return matrix4f;
    }

    public static void applyFirstPersonPositioningTransform(class_4587 poseStack, BedrockAnimatedModel model, class_1799 stack) {
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        // 应用瞄准定位
        List<BedrockPart> idleNodePath = model.getIdleSightPath();

        Matrix4f idleViewMatrix = getPositioningNodeInverse(idleNodePath);

        // 应用瞄准变换
        MathUtil.applyMatrixLerp(transformMatrix, idleViewMatrix, transformMatrix, 1);

        // 应用变换到 PoseStack
        poseStack.method_46416(0, 1.5f, 0);
        poseStack.method_34425(transformMatrix);
        poseStack.method_46416(0, -1.5f, 0);
    }
}
