package com.tacz.guns.compat.jei.entry;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.compat.jei.category.AttachmentQueryCategory;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class AttachmentQueryEntry {
    /**
     * 显示的配件
     */
    private final class_1799 attachmentStack;
    /**
     * 用于能显示的枪械
     */
    private List<class_1799> allowGunStacks;
    /**
     * 如果是显示不下的，那么全放这里
     */
    private List<class_1799> extraAllowGunStacks;

    public AttachmentQueryEntry(class_2960 attachmentId, GunTabType type) {
        this.attachmentStack = AttachmentItemBuilder.create().setId(attachmentId).build();
        this.allowGunStacks = Lists.newArrayList();
        this.extraAllowGunStacks = Lists.newArrayList();
        this.addAllAllowGuns(type);
        this.dividedGuns();
    }

    public static List<AttachmentQueryEntry> getAllAttachmentQueryEntries() {
        List<AttachmentQueryEntry> entries = Lists.newArrayList();
        TimelessAPI.getAllCommonAttachmentIndex().forEach(entry -> {
            if (entry.getValue().getPojo().isHidden()) {
                return;
            }
            for (GunTabType tabType : GunTabType.values()) {
                AttachmentQueryEntry queryEntry = new AttachmentQueryEntry(entry.getKey(), tabType);
                if (!queryEntry.getAllowGunStacks().isEmpty()) {
                    entries.add(queryEntry);
                }
            }
        });
        return entries;
    }

    public class_1799 getAttachmentStack() {
        return attachmentStack;
    }

    public List<class_1799> getAllowGunStacks() {
        return allowGunStacks;
    }

    public List<class_1799> getExtraAllowGunStacks() {
        return extraAllowGunStacks;
    }

    private void addAllAllowGuns(GunTabType type) {
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String tabType = type.name().toLowerCase(Locale.US);
            String gunType = entry.getValue().getType();
            if (tabType.equals(gunType)) {
                class_1799 gun = GunItemBuilder.create().setId(entry.getKey()).build();
                if (!(gun.method_7909() instanceof IGun iGun)) {
                    return;
                }
                if (iGun.allowAttachment(gun, this.attachmentStack)) {
                    this.allowGunStacks.add(gun);
                }
            }
        });
    }

    private void dividedGuns() {
        int size = this.allowGunStacks.size();
        if (size >= AttachmentQueryCategory.MAX_GUN_SHOW_COUNT) {
            this.extraAllowGunStacks = this.allowGunStacks.subList(AttachmentQueryCategory.MAX_GUN_SHOW_COUNT, size);
            this.allowGunStacks = this.allowGunStacks.subList(0, AttachmentQueryCategory.MAX_GUN_SHOW_COUNT);
        }
    }
}
