package com.tacz.guns.compat.kubejs.events;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.event.common.*;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4587;

public interface TimelessForgeEventWrappers {
    interface ForgeEventWrapper<E extends BaseEvent> {
        E getForgeEvent();
    }

    //Common Events
    interface AttachmentPropertyWrapper extends ForgeEventWrapper<AttachmentPropertyEvent> {
        default class_1799 getGunItem() {
            return getForgeEvent().getGunItem();
        }

        default AttachmentCacheProperty getCacheProperty() {
            return getForgeEvent().getCacheProperty();
        }
    }

    interface EntityHurtByGunWrapper<E extends EntityHurtByGunEvent> extends ForgeEventWrapper<E> {
        default class_1297 getBullet() {
            return getForgeEvent().getBullet();
        }

        @Nullable
        default class_1297 getHurtEntity() {
            return getForgeEvent().getHurtEntity();
        }

        @Nullable
        default class_1309 getAttacker() {
            return getForgeEvent().getAttacker();
        }

        default class_2960 getGunId() {
            return getForgeEvent().getGunId();
        }

        default float getBaseAmount() {
            return getForgeEvent().getBaseAmount();
        }

        default class_1282 getDamageSource(GunDamageSourcePart part) {
            return getForgeEvent().getDamageSource(part);
        }

        default float getHeadshotMultiplier() {
            return getForgeEvent().getHeadshotMultiplier();
        }

        default boolean isHeadShot() {
            return getForgeEvent().isHeadShot();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface EntityHurtByGunPreWrapper extends EntityHurtByGunWrapper<EntityHurtByGunEvent.Pre> {
        default void setHurtEntity(@Nullable class_1297 hurtEntity) {
            getForgeEvent().setHurtEntity(hurtEntity);
        }

        default void setAttacker(@Nullable class_1309 attacker) {
            getForgeEvent().setAttacker(attacker);
        }

        default void setGunId(class_2960 gunId) {
            getForgeEvent().setGunId(gunId);
        }

        default void setBaseAmount(float baseAmount) {
            getForgeEvent().setBaseAmount(baseAmount);
        }

        default void setDamageSource(GunDamageSourcePart part, class_1282 value) {
            getForgeEvent().setDamageSource(part, value);
        }

        default void setHeadshot(boolean headshot) {
            getForgeEvent().setHeadshot(headshot);
        }

        default void setHeadshotMultiplier(float headshotMultiplier) {
            getForgeEvent().setHeadshotMultiplier(headshotMultiplier);
        }
    }

    interface EntityKillByGunWrapper extends ForgeEventWrapper<EntityKillByGunEvent> {
        default class_1297 getBullet() {
            return getForgeEvent().getBullet();
        }

        @Nullable
        default class_1309 getKilledEntity() {
            return getForgeEvent().getKilledEntity();
        }

        @Nullable
        default class_1309 getAttacker() {
            return getForgeEvent().getAttacker();
        }

        default class_2960 getGunId() {
            return getForgeEvent().getGunId();
        }

        default float getBaseDamage() {
            return getForgeEvent().getBaseDamage();
        }

        default class_1282 getDamageSource(GunDamageSourcePart part) {
            return getForgeEvent().getDamageSource(part);
        }

        default boolean isHeadShot() {
            return getForgeEvent().isHeadShot();
        }

        default float getHeadshotMultiplier() {
            return getForgeEvent().getHeadshotMultiplier();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }

        default class_2960 getGunDisplayId() {
            return getForgeEvent().getGunDisplayId();
        }
    }

    interface GunDrawWrapper extends ForgeEventWrapper<GunDrawEvent> {
        default class_1309 getEntity() {
            return getForgeEvent().getEntity();
        }

        default class_1799 getPreviousGunItem() {
            return getForgeEvent().getPreviousGunItem();
        }

        default class_1799 getCurrentGunItem() {
            return getForgeEvent().getCurrentGunItem();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunFinishReloadWrapper extends ForgeEventWrapper<GunFinishReloadEvent> {
        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunFireWrapper extends ForgeEventWrapper<GunFireEvent> {
        default class_1309 getShooter() {
            return getForgeEvent().getShooter();
        }

        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunFireSelectWrapper extends ForgeEventWrapper<GunFireSelectEvent> {
        default class_1309 getShooter() {
            return getForgeEvent().getShooter();
        }

        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunMeleeWrapper extends ForgeEventWrapper<GunMeleeEvent> {
        default class_1309 getShooter() {
            return getForgeEvent().getShooter();
        }

        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunReloadWrapper extends ForgeEventWrapper<GunReloadEvent> {
        default class_1309 getEntity() {
            return getForgeEvent().getEntity();
        }

        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    interface GunShootWrapper extends ForgeEventWrapper<GunShootEvent> {
        default class_1309 getShooter() {
            return getForgeEvent().getShooter();
        }

        default class_1799 getGunItemStack() {
            return getForgeEvent().getGunItemStack();
        }

        default LogicalSide getLogicalSide() {
            return getForgeEvent().getLogicalSide();
        }
    }

    //Server Events
    interface AmmoHitBlockWrapper extends ForgeEventWrapper<AmmoHitBlockEvent> {
        default class_1937 getLevel() {
            return getForgeEvent().getLevel();
        }

        default class_3965 getHitResult() {
            return getForgeEvent().getHitResult();
        }

        default class_2680 getState() {
            return getForgeEvent().getState();
        }

        default EntityKineticBullet getAmmo() {
            return getForgeEvent().getAmmo();
        }
    }

    //Client Events
    interface BeforeRenderHandWrapper extends ForgeEventWrapper<BeforeRenderHandEvent> {
        default class_4587 getPoseStack() {
            return getForgeEvent().getPoseStack();
        }
    }
}
