package com.tacz.guns.compat.playeranimator.animation;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.*;

public class PlayerAnimatorAssetManager extends class_4080<Map<class_2960, HashMap<String, KeyframeAnimation>>> implements IdentifiableResourceReloadListener {
    private static PlayerAnimatorAssetManager INSTANCE;

    private final class_7654 filetoidconverter = new class_7654("player_animator", ".json");
    private final HashMap<class_2960, HashMap<String, KeyframeAnimation>> animations = new HashMap<>();

    public static PlayerAnimatorAssetManager get() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerAnimatorAssetManager();
        }
        return INSTANCE;
    }

    void putAnimation(class_2960 id, InputStream stream) throws IOException {
        List<KeyframeAnimation> keyframeAnimations = AnimationSerializing.deserializeAnimation(stream);
        for (var animation : keyframeAnimations) {
            if (animation.extraData.get("name") instanceof String text) {
                String name = PlayerAnimationRegistry.serializeTextToString(text).toLowerCase(Locale.ENGLISH);
                animations.computeIfAbsent(id, k -> Maps.newHashMap()).put(name, animation);
            }
        }
    }

    Optional<KeyframeAnimation> getAnimations(class_2960 id, String name) {
        var animationHashMap = this.animations.get(id);
        if (animationHashMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(animationHashMap.get(name));
    }

    public boolean containsKey(class_2960 id) {
        return animations.containsKey(id);
    }

    public void clearAll() {
        animations.clear();
    }

    @Override
    protected Map<class_2960, HashMap<String, KeyframeAnimation>> method_18789(class_3300 manager, class_3695 profiler) {
        Map<class_2960, HashMap<String, KeyframeAnimation>> output = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(manager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            try (Reader reader = entry.getValue().method_43039()) {
                List<KeyframeAnimation> keyframeAnimations = AnimationSerializing.deserializeAnimation(reader);
                for (var animation : keyframeAnimations) {
                    if (animation.extraData.get("name") instanceof String text) {
                        String name = PlayerAnimationRegistry.serializeTextToString(text).toLowerCase(Locale.ENGLISH);
                        output.computeIfAbsent(resourcelocation1, k -> Maps.newHashMap()).put(name, animation);
                    }
                }
            } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                GunMod.LOGGER.warn("Failed to player animation file: {}, entry: {}", resourcelocation, entry);
            }
        }
        return output;
    }

    @Override
    protected void apply(Map<class_2960, HashMap<String, KeyframeAnimation>> map, class_3300 manager, class_3695 profiler) {
        animations.clear();
        animations.putAll(map);
    }

    public static final class_2960 ID = new class_2960(GunMod.MOD_ID, "pa_asset_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}