package com.tacz.guns.config.util;

import com.google.common.collect.Lists;
import com.tacz.guns.GunMod;
import com.tacz.guns.config.sync.SyncConfig;
import org.apache.commons.lang3.StringUtils;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class InteractKeyConfigRead {
    private static final EnumMap<Type, List<class_2960>> WHITELIST = new EnumMap<>(Type.class);
    private static final EnumMap<Type, List<class_2960>> BLACKLIST = new EnumMap<>(Type.class);
    private static final class_6862<class_2248> WHITELIST_BLOCKS = class_6862.method_40092(class_7924.field_41254, new class_2960(GunMod.MOD_ID, "interact_key/whitelist"));
    private static final class_6862<class_2248> BLACKLIST_BLOCKS = class_6862.method_40092(class_7924.field_41254, new class_2960(GunMod.MOD_ID, "interact_key/blacklist"));
    private static final class_6862<class_1299<?>> WHITELIST_ENTITIES = class_6862.method_40092(class_7924.field_41266, new class_2960(GunMod.MOD_ID, "interact_key/whitelist"));
    private static final class_6862<class_1299<?>> BLACKLIST_ENTITIES = class_6862.method_40092(class_7924.field_41266, new class_2960(GunMod.MOD_ID, "interact_key/blacklist"));

    public static void init() {
        WHITELIST.clear();
        BLACKLIST.clear();
        handleConfigData(SyncConfig.INTERACT_KEY_WHITELIST_BLOCKS.get(), WHITELIST, Type.BLOCK);
        handleConfigData(SyncConfig.INTERACT_KEY_WHITELIST_ENTITIES.get(), WHITELIST, Type.ENTITY);
        handleConfigData(SyncConfig.INTERACT_KEY_BLACKLIST_BLOCKS.get(), BLACKLIST, Type.BLOCK);
        handleConfigData(SyncConfig.INTERACT_KEY_BLACKLIST_ENTITIES.get(), BLACKLIST, Type.ENTITY);
    }

    public static boolean canInteractBlock(class_2680 block) {
        class_2960 blockId = class_7923.field_41175.method_10221(block.method_26204());
        if (blockId == null) {
            return false;
        }
        // 先检查黑名单
        if (BLACKLIST.containsKey(Type.BLOCK) && BLACKLIST.get(Type.BLOCK).contains(blockId)) {
            return false;
        }
        if (block.method_26164(BLACKLIST_BLOCKS)) {
            return false;
        }
        // 再检查白名单
        if (WHITELIST.containsKey(Type.BLOCK) && WHITELIST.get(Type.BLOCK).contains(blockId)) {
            return true;
        }
        return block.method_26164(WHITELIST_BLOCKS);
    }

    public static boolean canInteractEntity(class_1297 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221(entity.method_5864());
        if (entityId == null) {
            return false;
        }
        // 先检查黑名单
        if (BLACKLIST.containsKey(Type.ENTITY) && BLACKLIST.get(Type.ENTITY).contains(entityId)) {
            return false;
        }
        if (entity.method_5864().method_20210(BLACKLIST_ENTITIES)) {
            return false;
        }
        // 再检查白名单
        if (WHITELIST.containsKey(Type.ENTITY) && WHITELIST.get(Type.ENTITY).contains(entityId)) {
            return true;
        }
        return entity.method_5864().method_20210(WHITELIST_ENTITIES);
    }

    private static void handleConfigData(List<String> configData, EnumMap<Type, List<class_2960>> storeList, Type type) {
        configData.forEach(data -> {
            if (data.isEmpty()) {
                return;
            }
            if (StringUtils.isBlank(data)) {
                return;
            }
            class_2960 id = new class_2960(data);
            storeList.computeIfAbsent(type, t -> Lists.newArrayList()).add(id);
        });
    }

    public enum Type {
        BLOCK, ENTITY;
    }
}
