package com.tacz.guns.crafting;

import com.google.gson.JsonObject;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.recipe.TableRecipe;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

/**
 * 工作台配方序列化器
 */
public class GunSmithTableSerializer implements class_1865<GunSmithTableRecipe> {
    @Override
    @Nullable
    public GunSmithTableRecipe method_8121(class_2960 id, JsonObject jsonObject) {
        TableRecipe tableRecipe = CommonAssetsManager.GSON.fromJson(jsonObject, TableRecipe.class);
        if (tableRecipe != null) {
            return new GunSmithTableRecipe(id, tableRecipe);
        }
        return null;
    }

    @Nullable
    @Override
    public GunSmithTableRecipe method_8122(class_2960 recipeId, class_2540 buffer) {
        int size = buffer.readInt();
        List<GunSmithTableIngredient> ingredients = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            ingredients.add(new GunSmithTableIngredient(class_1856.method_8086(buffer), buffer.readInt()));
        }
        class_1799 resultItem = buffer.method_10819();
        class_2960 group = buffer.method_10810();
        GunSmithTableResult result = new GunSmithTableResult(resultItem, group);
        return new GunSmithTableRecipe(recipeId, result, ingredients);
    }

    @Override
    public void toNetwork(class_2540 buffer, GunSmithTableRecipe recipe) {
        buffer.writeInt(recipe.getInputs().size());
        for (GunSmithTableIngredient ingredient : recipe.getInputs()) {
            ingredient.getIngredient().method_8088(buffer);
            buffer.writeInt(ingredient.getCount());
        }
        buffer.method_10793(recipe.getResult().getResult());
        buffer.method_10812(recipe.getResult().getGroup());
    }
}
