package com.tacz.guns.entity.sync;

import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.entity.sync.core.IDataSerializer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class ModSerializers {
    public static final IDataSerializer<ReloadState> RELOAD_STATE = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, ReloadState value) {
            buf.writeInt(value.getStateType().ordinal());
            buf.writeLong(value.getCountDown());
        }

        @Override
        public ReloadState read(class_2540 buf) {
            ReloadState reloadState = new ReloadState();
            reloadState.setStateType(ReloadState.StateType.values()[buf.readInt()]);
            reloadState.setCountDown(buf.readLong());
            return reloadState;
        }

        @Override
        public class_2520 write(ReloadState value) {
            class_2487 compound = new class_2487();
            compound.method_10582("StateType", value.getStateType().toString());
            compound.method_10544("CountDown", value.getCountDown());
            return compound;
        }

        @Override
        public ReloadState read(class_2520 nbt) {
            class_2487 compound = (class_2487) nbt;
            try {
                ReloadState.StateType stateType = ReloadState.StateType.valueOf(compound.method_10558("StateType"));
                long countDown = compound.method_10537("CountDown");
                ReloadState reloadState = new ReloadState();
                reloadState.setStateType(stateType);
                reloadState.setCountDown(countDown);
                return reloadState;
            } catch (IllegalArgumentException ignore) {
            }
            return new ReloadState();
        }
    };
}
