package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.inventory.GunSmithTableMenu;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessageCraft implements FabricPacket {
    public static final PacketType<ClientMessageCraft> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_craft"), ClientMessageCraft::new);

    private final class_2960 recipeId;
    private final int menuId;

    public ClientMessageCraft(class_2540 buf) {
        this(buf.method_10810(), buf.method_10816());
    }

    public ClientMessageCraft(class_2960 recipeId, int menuId) {
        this.recipeId = recipeId;
        this.menuId = menuId;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10812(recipeId);
        buf.method_10804(menuId);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        if (player.field_7512.field_7763 == menuId && player.field_7512 instanceof GunSmithTableMenu menu) {
            menu.doCraft(recipeId, player);
        }
    }
}
