package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.config.sync.SyncConfig;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessagePlayerCrawl implements FabricPacket {
    public static final PacketType<ClientMessagePlayerCrawl> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_player_crawl"), ClientMessagePlayerCrawl::new);

    private final boolean isCrawl;

    public ClientMessagePlayerCrawl(boolean isCrawl) {
        this.isCrawl = isCrawl;
    }

    public ClientMessagePlayerCrawl(class_2540 buf) {
        this.isCrawl = buf.readBoolean();
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeBoolean(isCrawl);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        if (!SyncConfig.ENABLE_CRAWL.get()) {
            return;
        }
        IGunOperator.fromLivingEntity(player).crawl(isCrawl);
    }
}
