package com.tacz.guns.network.message.event;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.GunDrawEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ServerMessageGunDraw implements FabricPacket {
    public static final PacketType<ServerMessageGunDraw> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_gundraw"), ServerMessageGunDraw::new);

    private final int entityId;
    private final class_1799 previousGunItem;
    private final class_1799 currentGunItem;

    public ServerMessageGunDraw(class_2540 buf) {
        this(buf.method_10816(), buf.method_10819(), buf.method_10819());
    }

    public ServerMessageGunDraw(int entityId, class_1799 previousGunItem, class_1799 currentGunItem) {
        this.entityId = entityId;
        this.previousGunItem = previousGunItem;
        this.currentGunItem = currentGunItem;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(entityId);
        buf.method_10793(previousGunItem);
        buf.method_10793(currentGunItem);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        doClientEvent(this);
    }

    @Environment(EnvType.CLIENT)
    private static void doClientEvent(ServerMessageGunDraw message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (level.method_8469(message.entityId) instanceof class_1309 livingEntity) {
            GunDrawEvent gunDrawEvent = new GunDrawEvent(livingEntity, message.previousGunItem, message.currentGunItem, LogicalSide.CLIENT);
            GunDrawEvent.CALLBACK.invoker().post(gunDrawEvent);
        }
    }
}
