package com.tacz.guns.network.message.event;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.GunFireSelectEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ServerMessageGunFireSelect implements FabricPacket {
    public static final PacketType<ServerMessageGunFireSelect> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_gunfire_select"), ServerMessageGunFireSelect::new);

    private final int shooterId;
    private final class_1799 gunItemStack;

    public ServerMessageGunFireSelect(class_2540 buf) {
        this(buf.method_10816(), buf.method_10819());
    }

    public ServerMessageGunFireSelect(int shooterId, class_1799 gunItemStack) {
        this.shooterId = shooterId;
        this.gunItemStack = gunItemStack;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(shooterId);
        buf.method_10793(gunItemStack);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        doClientEvent(this);
    }

    @Environment(EnvType.CLIENT)
    private static void doClientEvent(ServerMessageGunFireSelect message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (level.method_8469(message.shooterId) instanceof class_1309 shooter) {
            GunFireSelectEvent gunFireSelectEvent = new GunFireSelectEvent(shooter, message.gunItemStack, LogicalSide.CLIENT);
            GunFireSelectEvent.CALLBACK.invoker().post(gunFireSelectEvent);
        }
    }
}
