package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;


public class RecipeFilterManager extends class_4080<Map<class_2960, List<JsonElement>>> implements INetworkCacheReloadListener {
    private final Map<class_2960, RecipeFilter> filters = Maps.newHashMap();

    private final Gson gson;
    private final Marker marker;

    private final class_7654 fileToIdConverter;
    protected Map<class_2960, String> networkCache;

    public RecipeFilterManager() {
        this.gson = CommonAssetsManager.GSON;
        this.marker = MarkerFactory.getMarker("RecipeFilter");
        this.fileToIdConverter = class_7654.method_45114("recipe_filters");
    }

    @NotNull
    @Override
    protected Map<class_2960, List<JsonElement>> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    @Override
    protected void apply(Map<class_2960, List<JsonElement>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        filters.clear();

        ImmutableMap.Builder<class_2960, String> builder = ImmutableMap.builder();

        for (Map.Entry<class_2960, List<JsonElement>> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();

            for (JsonElement element : entry.getValue()) {
                try {
                    RecipeFilter data = parseJson(element);
                    filters.compute(id, (key, value) -> {
                        if (value == null) {
                            return data;
                        } else {
                            value.merge(data);
                            return value;
                        }
                    });
                } catch (JsonParseException | IllegalArgumentException e) {
                    GunMod.LOGGER.error(marker, "Failed to load data file {}", id, e);
                }
            }

            if (filters.containsKey(id)) {
                builder.put(id, gson.toJson(filters.get(id)));
            }
        }

        this.networkCache = builder.build();
    }

    private RecipeFilter parseJson(JsonElement element) {
        return gson.fromJson(element, RecipeFilter.class);
    }

    @Override
    public Map<class_2960, String> getNetworkCache() {
        return networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.RECIPE_FILTER;
    }

    public Map<class_2960, RecipeFilter> getFilters() {
        return filters;
    }

    public RecipeFilter getFilter(class_2960 id) {
        return filters.get(id);
    }

    public static final class_2960 ID = new class_2960(GunMod.MOD_ID, "recipe_filter_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
