/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.AnimationListener;
import com.tacz.guns.api.client.animation.ObjectAnimationChannel;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.bedrock.ModelRendererWrapper;
import com.tacz.guns.client.model.functional.AttachmentRender;
import com.tacz.guns.client.model.functional.BeamRenderer;
import com.tacz.guns.client.model.functional.LeftHandRender;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.RightHandRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.model.functional.TextShowRender;
import com.tacz.guns.client.model.listener.model.ModelAdditionalMagazineListener;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.pojo.display.gun.TextShow;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.util.RenderHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;

public class BedrockGunModel
extends BedrockAnimatedModel {
    protected final EnumMap<AttachmentType, List<BedrockPart>> refitAttachmentViewPath = Maps.newEnumMap(AttachmentType.class);
    private final EnumMap<AttachmentType, class_1799> currentAttachmentItem = Maps.newEnumMap(AttachmentType.class);
    private final Set<String> adapterToRender = Sets.newHashSet();
    private final ArrayList<ShellRender> shellRenderList = new ArrayList();
    @Nullable
    protected List<BedrockPart> ironSightPath;
    @Nullable
    protected List<BedrockPart> idleSightPath;
    @Nullable
    protected List<BedrockPart> thirdPersonHandOriginPath;
    @Nullable
    protected List<BedrockPart> fixedOriginPath;
    @Nullable
    protected List<BedrockPart> groundOriginPath;
    @Nullable
    protected List<BedrockPart> scopePosPath;
    @Nullable
    protected List<BedrockPart> muzzleFlashPosPath;
    @Nullable
    protected BedrockPart root;
    @Nullable
    protected BedrockPart magazineNode = Optional.ofNullable((ModelRendererWrapper)this.modelMap.get("magazine")).map(ModelRendererWrapper::getModelRenderer).orElse(null);
    @Nullable
    protected BedrockPart additionalMagazineNode = Optional.ofNullable((ModelRendererWrapper)this.modelMap.get("additional_magazine")).map(ModelRendererWrapper::getModelRenderer).orElse(null);
    @Nullable
    protected List<BedrockPart> laserBeamPaths;
    private boolean renderHand = true;
    private class_1799 currentGunItem;
    private int currentExtendMagLevel = 0;

    public BedrockGunModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        this.setFunctionalRenderer("lefthand_pos", bedrockPart -> new LeftHandRender(this));
        this.setFunctionalRenderer("righthand_pos", bedrockPart -> new RightHandRender(this));
        this.setFunctionalRenderer("muzzle_flash", bedrockPart -> new MuzzleFlashRender(this));
        this.setFunctionalRenderer("bullet_in_barrel", bedrockPart -> this.ammoHiddenRender((BedrockPart)bedrockPart, iGun -> iGun.hasBulletInBarrel(this.currentGunItem)));
        this.setFunctionalRenderer("bullet_in_mag", bedrockPart -> this.ammoHiddenRender((BedrockPart)bedrockPart, iGun -> iGun.getCurrentAmmoCount(this.currentGunItem) > 0));
        this.setFunctionalRenderer("bullet_chain", bedrockPart -> this.ammoHiddenRender((BedrockPart)bedrockPart, iGun -> iGun.getCurrentAmmoCount(this.currentGunItem) > 0));
        this.setFunctionalRenderer("mount", bedrockPart -> this.scopeHiddenRender((BedrockPart)bedrockPart, scopeItem -> scopeItem != null && !scopeItem.method_7960()));
        this.setFunctionalRenderer("carry", bedrockPart -> this.scopeHiddenRender((BedrockPart)bedrockPart, scopeItem -> scopeItem == null || scopeItem.method_7960()));
        this.setFunctionalRenderer("sight_folded", bedrockPart -> this.scopeHiddenRender((BedrockPart)bedrockPart, scopeItem -> scopeItem != null && !scopeItem.method_7960()));
        this.setFunctionalRenderer("sight", bedrockPart -> this.scopeHiddenRender((BedrockPart)bedrockPart, scopeItem -> scopeItem == null || scopeItem.method_7960()));
        this.setFunctionalRenderer("mag_extended_1", bedrockPart -> this.extendedMagHiddenRender((BedrockPart)bedrockPart, 1));
        this.setFunctionalRenderer("mag_extended_2", bedrockPart -> this.extendedMagHiddenRender((BedrockPart)bedrockPart, 2));
        this.setFunctionalRenderer("mag_extended_3", bedrockPart -> this.extendedMagHiddenRender((BedrockPart)bedrockPart, 3));
        this.setFunctionalRenderer("mag_standard", bedrockPart -> this.extendedMagHiddenRender((BedrockPart)bedrockPart, 0));
        this.setFunctionalRenderer("additional_magazine", this::renderAdditionalMagazine);
        this.setFunctionalRenderer("handguard_default", this::handguardDefaultRender);
        this.setFunctionalRenderer("handguard_tactical", this::handguardTacticalRender);
        this.cacheOtherPath();
        this.cacheRefitAttachmentViewPath();
        this.cacheShellOriginNodes();
        this.allAttachmentRender();
        this.setFunctionalRenderer("attachment_adapter", this::attachmentAdapterNodeRender);
    }

    private void cacheOtherPath() {
        this.ironSightPath = this.getPath((ModelRendererWrapper)this.modelMap.get("iron_view"));
        this.idleSightPath = this.getPath((ModelRendererWrapper)this.modelMap.get("idle_view"));
        this.thirdPersonHandOriginPath = this.getPath((ModelRendererWrapper)this.modelMap.get("thirdperson_hand"));
        this.fixedOriginPath = this.getPath((ModelRendererWrapper)this.modelMap.get("fixed"));
        this.groundOriginPath = this.getPath((ModelRendererWrapper)this.modelMap.get("ground"));
        this.muzzleFlashPosPath = this.getPath((ModelRendererWrapper)this.modelMap.get("muzzle_flash"));
        this.scopePosPath = this.getPath((ModelRendererWrapper)this.modelMap.get(AttachmentType.SCOPE.name().toLowerCase() + "_pos"));
        this.laserBeamPaths = this.getPath((ModelRendererWrapper)this.modelMap.get("laser_beam"));
        this.root = Optional.ofNullable((ModelRendererWrapper)this.modelMap.get("root")).map(ModelRendererWrapper::getModelRenderer).orElse(null);
    }

    private void cacheRefitAttachmentViewPath() {
        for (AttachmentType type : AttachmentType.values()) {
            if (type == AttachmentType.NONE) {
                this.refitAttachmentViewPath.put(type, this.getPath((ModelRendererWrapper)this.modelMap.get("refit_view")));
                continue;
            }
            String nodeName = "refit_" + type.name().toLowerCase() + "_view";
            this.refitAttachmentViewPath.put(type, this.getPath((ModelRendererWrapper)this.modelMap.get(nodeName)));
        }
    }

    private void cacheShellOriginNodes() {
        ModelRendererWrapper rendererWrapper = (ModelRendererWrapper)this.modelMap.get("shell");
        int i = 1;
        while (rendererWrapper != null) {
            ShellRender shellRender = new ShellRender(this);
            this.setFunctionalRenderer(rendererWrapper.getModelRenderer().name, bedrockPart -> shellRender);
            this.shellRenderList.add(shellRender);
            rendererWrapper = (ModelRendererWrapper)this.modelMap.get("shell_" + i);
            ++i;
        }
    }

    @Nullable
    private IFunctionalRenderer attachmentAdapterNodeRender(BedrockPart bedrockPart) {
        for (BedrockPart child : bedrockPart.children) {
            if (child.name == null) {
                child.visible = false;
                continue;
            }
            child.visible = this.adapterToRender.contains(child.name);
        }
        return null;
    }

    private void allAttachmentRender() {
        for (AttachmentType type : AttachmentType.values()) {
            if (type == AttachmentType.NONE || type == AttachmentType.SCOPE) continue;
            String positionNodeName = type.name().toLowerCase() + "_pos";
            String defaultNodeName = type.name().toLowerCase() + "_default";
            this.setFunctionalRenderer(positionNodeName, bedrockPart -> {
                bedrockPart.visible = false;
                return new AttachmentRender(this, type);
            });
            this.setFunctionalRenderer(defaultNodeName, bedrockPart -> {
                class_1799 attachmentItem = this.currentAttachmentItem.get((Object)type);
                if (type == AttachmentType.MUZZLE && BedrockGunModel.checkShowMuzzle(bedrockPart, attachmentItem)) {
                    return null;
                }
                bedrockPart.visible = attachmentItem == null || attachmentItem.method_7960();
                return null;
            });
        }
    }

    private static boolean checkShowMuzzle(BedrockPart bedrockPart, class_1799 attachmentItem) {
        class_2960 attachmentId;
        Optional<ClientAttachmentIndex> attachmentIndex;
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        if (iAttachment != null && (attachmentIndex = TimelessAPI.getClientAttachmentIndex(attachmentId = iAttachment.getAttachmentId(attachmentItem))).isPresent()) {
            bedrockPart.visible = attachmentIndex.get().isShowMuzzle();
            return true;
        }
        return false;
    }

    @Nullable
    private IFunctionalRenderer handguardTacticalRender(BedrockPart bedrockPart) {
        class_1799 laserItem = this.currentAttachmentItem.get((Object)AttachmentType.LASER);
        class_1799 gripItem = this.currentAttachmentItem.get((Object)AttachmentType.GRIP);
        bedrockPart.visible = !laserItem.method_7960() || !gripItem.method_7960();
        return null;
    }

    @Nullable
    private IFunctionalRenderer handguardDefaultRender(BedrockPart bedrockPart) {
        class_1799 laserItem = this.currentAttachmentItem.get((Object)AttachmentType.LASER);
        class_1799 gripItem = this.currentAttachmentItem.get((Object)AttachmentType.GRIP);
        bedrockPart.visible = laserItem.method_7960() && gripItem.method_7960();
        return null;
    }

    @NotNull
    private IFunctionalRenderer renderAdditionalMagazine(BedrockPart bedrockPart) {
        return (poseStack, vertexBuffer, transformType, light, overlay) -> {
            if (bedrockPart.visible) {
                bedrockPart.compile(poseStack.method_23760(), vertexBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                for (BedrockPart part : bedrockPart.children) {
                    part.render(poseStack, transformType, vertexBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.magazineNode != null && this.magazineNode.visible) {
                    this.magazineNode.compile(poseStack.method_23760(), vertexBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    for (BedrockPart part : this.magazineNode.children) {
                        part.render(poseStack, transformType, vertexBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
            }
        };
    }

    public void setTextShowList(Map<String, TextShow> textShowList) {
        textShowList.forEach((name, textShow) -> this.setFunctionalRenderer((String)name, bedrockPart -> new TextShowRender(this, (TextShow)textShow, this.currentGunItem)));
    }

    public void render(class_4587 matrixStack, class_1799 gunItem, class_811 transformType, class_1921 renderType, int light, int overlay) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        this.currentGunItem = gunItem;
        this.currentExtendMagLevel = 0;
        this.adapterToRender.clear();
        for (AttachmentType type : AttachmentType.values()) {
            if (type == AttachmentType.NONE) continue;
            class_1799 attachmentItem = iGun.getAttachment(gunItem, type);
            if (attachmentItem.method_7960()) {
                attachmentItem = iGun.getBuiltinAttachment(gunItem, type);
            }
            this.currentAttachmentItem.put(type, attachmentItem);
            IAttachment attachment = IAttachment.getIAttachmentOrNull(attachmentItem);
            if (attachment == null) continue;
            TimelessAPI.getClientAttachmentIndex(attachment.getAttachmentId(attachmentItem)).ifPresent(index -> {
                if (type == AttachmentType.EXTENDED_MAG) {
                    this.currentExtendMagLevel = index.getData().getExtendedMagLevel();
                }
                if (index.getAdapterNodeName() != null) {
                    this.adapterToRender.add(index.getAdapterNodeName());
                }
            });
        }
        if (this.laserBeamPaths != null) {
            BeamRenderer.renderLaserBeam(gunItem, matrixStack, transformType, this.laserBeamPaths);
        }
        class_1799 attachmentItem = this.currentAttachmentItem.get((Object)AttachmentType.SCOPE);
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        if (this.scopePosPath != null && attachmentItem != null && !attachmentItem.method_7960()) {
            matrixStack.method_22903();
            for (BedrockPart bedrockPart : this.scopePosPath) {
                bedrockPart.translateAndRotateAndScale(matrixStack);
            }
            AttachmentRender.renderAttachment(attachmentItem, this.currentGunItem, matrixStack, transformType, light, overlay);
            matrixStack.method_22909();
            if (iAttachment != null) {
                Optional<ClientAttachmentIndex> attachmentIndex = TimelessAPI.getClientAttachmentIndex(iAttachment.getAttachmentId(attachmentItem));
                attachmentIndex.ifPresent(index -> {
                    if (index.isScope() && index.isSight()) {
                        RenderHelper.enableItemEntityStencilTest();
                        RenderSystem.stencilFunc((int)516, (int)127, (int)255);
                    } else if (index.isScope()) {
                        RenderHelper.enableItemEntityStencilTest();
                        RenderSystem.stencilFunc((int)514, (int)0, (int)255);
                    }
                });
            }
        }
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        super.render(matrixStack, transformType, renderType, light, overlay);
        RenderHelper.disableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
    }

    @Nullable
    private IFunctionalRenderer ammoHiddenRender(BedrockPart bedrockPart, Predicate<IGun> predicate) {
        IGun iGun = IGun.getIGunOrNull(this.currentGunItem);
        if (iGun != null) {
            bedrockPart.visible = predicate.test(iGun);
        }
        return null;
    }

    @Nullable
    private IFunctionalRenderer scopeHiddenRender(BedrockPart bedrockPart, Predicate<class_1799> predicate) {
        class_1799 scopeItem = this.currentAttachmentItem.get((Object)AttachmentType.SCOPE);
        bedrockPart.visible = predicate.test(scopeItem);
        return null;
    }

    @Nullable
    private IFunctionalRenderer extendedMagHiddenRender(BedrockPart bedrockPart, int level) {
        bedrockPart.visible = this.currentExtendMagLevel == level;
        return null;
    }

    @Override
    public AnimationListener supplyListeners(String nodeName, ObjectAnimationChannel.ChannelType type) {
        AnimationListener listener = super.supplyListeners(nodeName, type);
        if (listener == null) {
            return null;
        }
        if (nodeName.equals("additional_magazine")) {
            return new ModelAdditionalMagazineListener(listener, this);
        }
        return listener;
    }

    @Override
    public void cleanAnimationTransform() {
        super.cleanAnimationTransform();
        if (this.additionalMagazineNode != null) {
            this.additionalMagazineNode.visible = false;
        }
    }

    public EnumMap<AttachmentType, class_1799> getCurrentAttachmentItem() {
        return this.currentAttachmentItem;
    }

    public class_1799 getCurrentGunItem() {
        return this.currentGunItem;
    }

    @Nullable
    public BedrockPart getAdditionalMagazineNode() {
        return this.additionalMagazineNode;
    }

    @Nullable
    public List<BedrockPart> getIronSightPath() {
        return this.ironSightPath;
    }

    @Override
    @Nullable
    public List<BedrockPart> getIdleSightPath() {
        return this.idleSightPath;
    }

    @Nullable
    public List<BedrockPart> getThirdPersonHandOriginPath() {
        return this.thirdPersonHandOriginPath;
    }

    @Nullable
    public List<BedrockPart> getFixedOriginPath() {
        return this.fixedOriginPath;
    }

    @Nullable
    public List<BedrockPart> getGroundOriginPath() {
        return this.groundOriginPath;
    }

    @Nullable
    public List<BedrockPart> getMuzzleFlashPosPath() {
        return this.muzzleFlashPosPath;
    }

    @Nullable
    public List<BedrockPart> getScopePosPath() {
        return this.scopePosPath;
    }

    @Nullable
    public List<BedrockPart> getRefitAttachmentViewPath(AttachmentType type) {
        return this.refitAttachmentViewPath.get((Object)type);
    }

    @Nullable
    public ShellRender getShellRender(int index) {
        if (index < 0 || index >= this.shellRenderList.size()) {
            return null;
        }
        return this.shellRenderList.get(index);
    }

    @Override
    @Nullable
    public BedrockPart getRootNode() {
        return this.root;
    }

    @Override
    public boolean getRenderHand() {
        return this.renderHand;
    }

    public void setRenderHand(boolean renderHand) {
        this.renderHand = renderHand;
    }
}

