/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.command.sub.DebugCommand;
import com.tacz.guns.debug.GunMeleeDebug;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.item.ModernKineticGunScriptAPI;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.EffectData;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import org.joml.Vector2d;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.slf4j.MarkerFactory;

public class ModernKineticGunItem
extends AbstractGunItem
implements GunItemDataAccessor {
    public static final String TYPE_NAME = "modern_kinetic";
    private static final DoubleFunction<class_1322> AM_FACTORY = amount -> new class_1322(UUID.randomUUID(), "TACZ Melee Damage", amount, class_1322.class_1323.field_6328);
    public final DefaultPropertyModification defaultPropertyModification = new DefaultPropertyModification();

    public ModernKineticGunItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Override
    public boolean startBolt(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public boolean tickBolt(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElseGet(() -> this.defaultTickBolt(api));
    }

    @Override
    public void shoot(ShooterDataHolder dataHolder, class_1799 gunItem, Supplier<Float> pitch, Supplier<Float> yaw, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        api.setPitchSupplier(pitch);
        api.setYawSupplier(yaw);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("shoot"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api)), () -> api.shootOnce(api.isShootingNeedConsumeAmmo()));
    }

    @Override
    public boolean startReload(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_reload"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public ReloadState tickReload(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return new ReloadState();
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_reload"))).map(func -> {
            ReloadState reloadState = new ReloadState();
            Varargs varargs = func.invoke((Varargs)CoerceJavaToLua.coerce((Object)api));
            int typeOrdinary = varargs.arg(1).checkint();
            long countDown = varargs.arg(2).checklong();
            reloadState.setStateType(ReloadState.StateType.values()[typeOrdinary]);
            reloadState.setCountDown(countDown);
            return reloadState;
        }).orElseGet(() -> this.defaultTickReload(api));
    }

    @Override
    public void interruptReload(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("interrupt_reload"))).ifPresent(func -> func.call(CoerceJavaToLua.coerce((Object)api)));
    }

    @Override
    public void melee(ShooterDataHolder dataHolder, class_1309 user, class_1799 gunItem) {
        class_2960 gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            GunMeleeData meleeData = gunIndex.getGunData().getMeleeData();
            float distance = meleeData.getDistance();
            class_2960 muzzleId = this.getAttachmentId(gunItem, AttachmentType.MUZZLE);
            MeleeData muzzleData = this.getMeleeData(muzzleId);
            if (muzzleData != null) {
                this.doMelee(user, distance, muzzleData.getDistance(), muzzleData.getRangeAngle(), muzzleData.getKnockback(), muzzleData.getDamage(), muzzleData.getEffects());
                return;
            }
            class_2960 stockId = this.getAttachmentId(gunItem, AttachmentType.STOCK);
            MeleeData stockData = this.getMeleeData(stockId);
            if (stockData != null) {
                this.doMelee(user, distance, stockData.getDistance(), stockData.getRangeAngle(), stockData.getKnockback(), stockData.getDamage(), stockData.getEffects());
                return;
            }
            GunDefaultMeleeData defaultData = meleeData.getDefaultMeleeData();
            if (defaultData == null) {
                return;
            }
            this.doMelee(user, distance, defaultData.getDistance(), defaultData.getRangeAngle(), defaultData.getKnockback(), defaultData.getDamage(), Collections.emptyList());
        });
    }

    @Override
    public void tickHeat(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        long heatTimestamp = dataHolder.heatTimestamp;
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_heat"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((double)heatTimestamp)), () -> this.defaultTickHeat(heatTimestamp, gunItem));
    }

    private void defaultTickHeat(long heatTimestamp, class_1799 gunItem) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem)).map(index -> index.getGunData().getHeatData()).ifPresent(heatData -> {
            if (iGun.getHeatAmount(gunItem) <= 0.0f) {
                return;
            }
            if (iGun.isOverheatLocked(gunItem)) {
                this.tickLocked(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            } else {
                this.tickNormal(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            }
        });
    }

    public void tickLocked(IGun iGun, class_1799 gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getOverHeatTime()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
            if (heatAmount <= 0.0f) {
                iGun.setOverheatLocked(gunStack, false);
            }
        }
    }

    public void tickNormal(IGun iGun, class_1799 gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getCoolingDelay()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
        }
    }

    @Override
    public <T> T modifyProperty(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter, String luaMethodName, String id, Class<T> type, T original) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return original;
        }
        Object afterDefaultModification = this.defaultPropertyModification.modify(gunItem, shooter, gunIndex, id, original);
        try {
            return (T)Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get(luaMethodName))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((String)id), CoerceJavaToLua.coerce((Object)afterDefaultModification))).map(luaValue -> type.cast(CoerceLuaToJava.coerce((LuaValue)luaValue, (Class)type))).orElse(afterDefaultModification);
        }
        catch (Exception exception) {
            GunMod.LOGGER.warn(MarkerFactory.getMarker((String)"Gun Script"), "Failed to modify gun property {}", (Object)id, (Object)exception);
            return afterDefaultModification;
        }
    }

    @Override
    public void doBulletSpread(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter, class_1676 projectile, int bulletCnt, float processedSpeed, float inaccuracy, float pitch, float yaw) {
        if (!(projectile instanceof EntityKineticBullet)) {
            return;
        }
        EntityKineticBullet bullet = (EntityKineticBullet)projectile;
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("calcSpread"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((int)bulletCnt), (LuaValue)LuaValue.valueOf((double)inaccuracy))).map(luaValue -> {
            if (luaValue.istable()) {
                LuaTable table = luaValue.checktable();
                return new Vector2d(table.get(1).checkdouble(), table.get(2).checkdouble());
            }
            return null;
        }).ifPresentOrElse(vector2d -> bullet.shootFromRotation((class_1297)shooter, pitch, yaw, 0.0f, processedSpeed, (Vector2d)vector2d), () -> bullet.method_24919((class_1297)shooter, pitch, yaw, 0.0f, processedSpeed, inaccuracy));
    }

    private boolean defaultTickBolt(ModernKineticGunScriptAPI api) {
        long boltFeedTime;
        GunData gunData = api.getGunIndex().getGunData();
        long boltActionTime = (long)(gunData.getBoltActionTime() * 1000.0f);
        float rawBoltFeedTime = gunData.getBoltFeedTime();
        long l = boltFeedTime = rawBoltFeedTime == -1.0f ? boltActionTime : (long)(gunData.getBoltFeedTime() * 1000.0f);
        if (api.getBoltTime() < boltFeedTime) {
            return true;
        }
        if (!api.hasAmmoInBarrel()) {
            if (api.useInventoryAmmo()) {
                if (api.consumeAmmoFromPlayer(1) == 1) {
                    api.setAmmoInBarrel(true);
                }
            } else if (api.removeAmmoFromMagazine(1) != 0) {
                api.setAmmoInBarrel(true);
            }
        }
        return api.getBoltTime() < boltActionTime;
    }

    private ReloadState defaultTickReload(ModernKineticGunScriptAPI api) {
        long countDown;
        ReloadState.StateType stateType;
        CommonGunIndex gunIndex = api.getGunIndex();
        GunData gunData = gunIndex.getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        ReloadState.StateType oldStateType = ReloadState.StateType.values()[api.getReloadStateType()];
        long progressTime = api.getReloadTime();
        if (oldStateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else if (oldStateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else {
            stateType = ReloadState.StateType.NOT_RELOADING;
            countDown = -1L;
        }
        if (oldStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, false);
        }
        if (oldStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, true);
        }
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }

    private void defaultReloadFinishing(ModernKineticGunScriptAPI api, boolean isTactical) {
        int i;
        GunData data = api.getGunIndex().getGunData();
        int needAmmoCount = api.getNeededAmmoAmount();
        boolean needConsumeAmmo = api.isReloadingNeedConsumeAmmo();
        boolean infinite = data.getReloadData().isInfinite();
        needConsumeAmmo = needConsumeAmmo || infinite;
        switch (data.getReloadData().getType()) {
            case MAGAZINE: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(needAmmoCount);
                    api.putAmmoInMagazine(consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
            case FUEL: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(1);
                    api.putAmmoInMagazine(needAmmoCount * consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
        }
        Bolt boltType = api.getGunIndex().getGunData().getBolt();
        if (!(isTactical || boltType != Bolt.MANUAL_ACTION && boltType != Bolt.CLOSED_BOLT || (i = api.removeAmmoFromMagazine(1)) == 0)) {
            api.setAmmoInBarrel(true);
        }
    }

    private void doMelee(class_1309 user, float gunDistance, float meleeDistance, float rangeAngle, float knockback, float damage, List<EffectData> effects) {
        double distance = gunDistance + meleeDistance;
        float xRot = (float)Math.toRadians(-user.method_36455());
        float yRot = (float)Math.toRadians(-user.method_36454());
        class_243 eyeVec = new class_243(0.0, 0.0, 1.0).method_1037(xRot).method_1024(yRot).method_1029().method_1021(distance);
        class_243 centrePos = user.method_33571().method_1020(eyeVec);
        List entityList = user.method_37908().method_18467(class_1309.class, user.method_5829().method_1014(distance));
        com.google.common.base.Supplier realDamage = Suppliers.memoize(() -> {
            class_1324 instance = user.method_5996(class_5134.field_23721);
            if (instance == null) {
                return Float.valueOf(damage);
            }
            double oldBase = instance.method_6201();
            class_1322 modifier = AM_FACTORY.apply(damage);
            try {
                instance.method_6192(0.0);
                instance.method_26835(modifier);
                Float f = Float.valueOf((float)instance.method_6194());
                return f;
            }
            finally {
                instance.method_6192(oldBase);
                instance.method_6202(modifier);
            }
        });
        for (class_1309 living : entityList) {
            double degree;
            class_243 targetVec = living.method_33571().method_1020(centrePos);
            double targetLength = targetVec.method_1033();
            if (targetLength < distance || !((degree = Math.toDegrees(Math.acos(targetVec.method_1026(eyeVec) / (targetLength * distance)))) < (double)(rangeAngle / 2.0f)) || !user.method_6057((class_1297)living)) continue;
            ModernKineticGunItem.doPerLivingHurt(user, living, knockback, ((Float)realDamage.get()).floatValue(), effects);
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7322(0.1f);
        }
        if (DebugCommand.DEBUG) {
            GunMeleeDebug.showRange(user, (int)Math.round(distance), centrePos, eyeVec, rangeAngle);
        }
    }

    private static void doPerLivingHurt(class_1309 user, class_1309 target, float knockback, float damage, List<EffectData> effects) {
        if (target.equals((Object)user)) {
            return;
        }
        target.method_6005((double)knockback, (double)((float)Math.sin(Math.toRadians(user.method_36454()))), (double)((float)(-Math.cos(Math.toRadians(user.method_36454())))));
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            target.method_5643(user.method_48923().method_48802(player), damage);
        } else {
            target.method_5643(user.method_48923().method_48812(user), damage);
        }
        user.method_5723(user, (class_1297)target);
        if (!target.method_5805()) {
            return;
        }
        for (EffectData effectData : effects) {
            class_1291 mobEffect = (class_1291)class_7923.field_41174.method_10223(effectData.getEffectId());
            if (mobEffect == null) continue;
            int time = Math.max(0, effectData.getTime() * 20);
            int amplifier = Math.max(0, effectData.getAmplifier());
            class_1293 effectInstance = new class_1293(mobEffect, time, amplifier, false, effectData.isHideParticles());
            target.method_6092(effectInstance);
        }
        class_1937 class_19372 = user.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int n = (int)((double)damage * 0.5);
            serverLevel.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), n, 0.1, 0.0, 0.1, 0.2);
        }
    }

    @Nullable
    private MeleeData getMeleeData(class_2960 attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }

    private LuaFunction checkFunction(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return (LuaFunction)luaValue;
        }
        if (luaValue.isnil()) {
            return null;
        }
        throw new LuaError("bad argument: function or nil expected, got " + luaValue.typename());
    }

    @Override
    public void fireSelect(ShooterDataHolder dataHolder, class_1799 gunItem) {
        class_2960 gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> {
            FireMode fireMode = this.getFireMode(gunItem);
            List<FireMode> fireModeSet = gunIndex.getGunData().getFireModeSet();
            int nextIndex = (fireModeSet.indexOf((Object)fireMode) + 1) % fireModeSet.size();
            FireMode nextFireMode = fireModeSet.get(nextIndex);
            this.setFireMode(gunItem, nextFireMode);
            return nextFireMode;
        });
    }

    @Override
    public int getLevel(int exp) {
        return 0;
    }

    @Override
    public int getExp(int level) {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }

    public class DefaultPropertyModification {
        public static final class_2960 SLUGS = new class_2960("tacz", "intrinsic/slug");

        public <T> T modify(class_1799 gunItem, class_1309 shooter, CommonGunIndex gunIndex, String id, T original) {
            if ("bullet_amount".equals(id) && AllowAttachmentTagMatcher.matchTag(SLUGS, ModernKineticGunItem.this.getAttachmentId(gunItem, AttachmentType.EXTENDED_MAG))) {
                return (T)Integer.valueOf(1);
            }
            return original;
        }
    }
}

