/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network;

import cn.sh1rocu.tacz.api.extension.IEntityAdditionalSpawnData;
import com.tacz.guns.network.HandshakeNetworking;
import com.tacz.guns.network.IHandshakeMessage;
import com.tacz.guns.network.message.ClientMessageCraft;
import com.tacz.guns.network.message.ClientMessageLaserColor;
import com.tacz.guns.network.message.ClientMessagePlayerAim;
import com.tacz.guns.network.message.ClientMessagePlayerBoltGun;
import com.tacz.guns.network.message.ClientMessagePlayerCancelReload;
import com.tacz.guns.network.message.ClientMessagePlayerCrawl;
import com.tacz.guns.network.message.ClientMessagePlayerDrawGun;
import com.tacz.guns.network.message.ClientMessagePlayerFireSelect;
import com.tacz.guns.network.message.ClientMessagePlayerMelee;
import com.tacz.guns.network.message.ClientMessagePlayerReloadGun;
import com.tacz.guns.network.message.ClientMessagePlayerShoot;
import com.tacz.guns.network.message.ClientMessagePlayerZoom;
import com.tacz.guns.network.message.ClientMessageRefitGun;
import com.tacz.guns.network.message.ClientMessageSyncBaseTimestamp;
import com.tacz.guns.network.message.ClientMessageUnloadAttachment;
import com.tacz.guns.network.message.ServerMessageCraft;
import com.tacz.guns.network.message.ServerMessageLevelUp;
import com.tacz.guns.network.message.ServerMessageRefreshRefitScreen;
import com.tacz.guns.network.message.ServerMessageSound;
import com.tacz.guns.network.message.ServerMessageSwapItem;
import com.tacz.guns.network.message.ServerMessageSyncBaseTimestamp;
import com.tacz.guns.network.message.ServerMessageSyncGunPack;
import com.tacz.guns.network.message.ServerMessageUpdateEntityData;
import com.tacz.guns.network.message.event.ServerMessageGunDraw;
import com.tacz.guns.network.message.event.ServerMessageGunFire;
import com.tacz.guns.network.message.event.ServerMessageGunFireSelect;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.network.message.event.ServerMessageGunMelee;
import com.tacz.guns.network.message.event.ServerMessageGunReload;
import com.tacz.guns.network.message.event.ServerMessageGunShoot;
import com.tacz.guns.network.message.handshake.AcknowledgeC2SPacket;
import com.tacz.guns.network.message.handshake.SyncedEntityDataMappingS2CPacket;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientLoginNetworkHandlerAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class NetworkHandler {
    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerShoot.TYPE, ClientMessagePlayerShoot::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerReloadGun.TYPE, ClientMessagePlayerReloadGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerCancelReload.TYPE, ClientMessagePlayerCancelReload::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerFireSelect.TYPE, ClientMessagePlayerFireSelect::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerAim.TYPE, ClientMessagePlayerAim::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerCrawl.TYPE, ClientMessagePlayerCrawl::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerDrawGun.TYPE, ClientMessagePlayerDrawGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageCraft.TYPE, ClientMessageCraft::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerZoom.TYPE, ClientMessagePlayerZoom::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageRefitGun.TYPE, ClientMessageRefitGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageUnloadAttachment.TYPE, ClientMessageUnloadAttachment::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerBoltGun.TYPE, ClientMessagePlayerBoltGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerMelee.TYPE, ClientMessagePlayerMelee::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageSyncBaseTimestamp.TYPE, ClientMessageSyncBaseTimestamp::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageLaserColor.TYPE, ClientMessageLaserColor::handle);
        HandshakeNetworking.register(AcknowledgeC2SPacket.ID, AcknowledgeC2SPacket.class);
        HandshakeNetworking.register(SyncedEntityDataMappingS2CPacket.TYPE, SyncedEntityDataMappingS2CPacket.class);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)IEntityAdditionalSpawnData.EXTRA_DATA_PACKET, (client, handler, buf, responseSender) -> {
            int entityId = buf.method_10816();
            buf.retain();
            client.execute(() -> {
                class_1297 entity = Objects.requireNonNull(client.field_1687).method_8469(entityId);
                if (entity instanceof IEntityAdditionalSpawnData) {
                    IEntityAdditionalSpawnData extra = (IEntityAdditionalSpawnData)entity;
                    extra.readSpawnData(buf);
                }
                buf.release();
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageSound.TYPE, ServerMessageSound::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageCraft.TYPE, ServerMessageCraft::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageRefreshRefitScreen.TYPE, ServerMessageRefreshRefitScreen::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageSwapItem.TYPE, ServerMessageSwapItem::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageLevelUp.TYPE, ServerMessageLevelUp::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunHurt.TYPE, ServerMessageGunHurt::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunKill.TYPE, ServerMessageGunKill::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageUpdateEntityData.TYPE, ServerMessageUpdateEntityData::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageSyncGunPack.TYPE, ServerMessageSyncGunPack::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunDraw.TYPE, ServerMessageGunDraw::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunFire.TYPE, ServerMessageGunFire::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunFireSelect.TYPE, ServerMessageGunFireSelect::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunMelee.TYPE, ServerMessageGunMelee::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunReload.TYPE, ServerMessageGunReload::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageGunShoot.TYPE, ServerMessageGunShoot::handle);
        ClientPlayNetworking.registerGlobalReceiver(ServerMessageSyncBaseTimestamp.TYPE, ServerMessageSyncBaseTimestamp::handle);
    }

    @Environment(value=EnvType.CLIENT)
    static <T extends IHandshakeMessage> void registerHandshake(PacketType<T> type) {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)type.getId(), (client, handler, buf, listenerAdder) -> {
            IHandshakeMessage packet = (IHandshakeMessage)type.read(buf);
            class_2535 connection = ((ClientLoginNetworkHandlerAccessor)handler).getConnection();
            IHandshakeMessage.IResponsePacket responsePacket = packet.handle(connection, listenerAdder);
            class_2540 response = PacketByteBufs.create();
            if (responsePacket != null) {
                response.method_10812(responsePacket.getId());
                responsePacket.write(response);
            }
            return CompletableFuture.completedFuture(response);
        });
    }

    public static void sendToClientPlayer(FabricPacket message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)message);
    }

    public static void sendToTrackingEntityAndSelf(class_1297 centerEntity, FabricPacket message) {
        class_1937 class_19372 = centerEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (class_3222 player : PlayerLookup.tracking((class_3218)serverLevel, (class_2338)centerEntity.method_24515())) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)message);
            }
        }
    }

    public static void sendToAllPlayers(FabricPacket message, MinecraftServer server) {
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)message);
        }
    }

    public static void sendToTrackingEntity(FabricPacket message, class_1297 centerEntity) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)centerEntity)) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)message);
        }
    }

    public static void sendToDimension(FabricPacket message, class_1297 centerEntity) {
        class_1937 class_19372 = centerEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)message);
            }
        }
    }
}

