/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ClientMessageLaserColor
implements FabricPacket {
    public static final PacketType<ClientMessageLaserColor> TYPE = PacketType.create((class_2960)new class_2960("tacz", "c2s_laser_color"), ClientMessageLaserColor::new);
    private final Map<AttachmentType, Integer> colorMap = new HashMap<AttachmentType, Integer>();
    private boolean applyGunColor = false;
    private int gunColor = 0;
    private int gunSlotIndex = -1;

    private ClientMessageLaserColor() {
    }

    public ClientMessageLaserColor(class_2540 buf) {
        this.colorMap.putAll(buf.method_34067(buf1 -> (AttachmentType)buf.method_10818(AttachmentType.class), class_2540::readInt));
        this.applyGunColor = buf.readBoolean();
        this.gunColor = buf.readInt();
        this.gunSlotIndex = buf.readInt();
    }

    public ClientMessageLaserColor(@NotNull class_1799 gun, int gunSlotIndex) {
        AttachmentType[] attachmentTypeArray = gun.method_7909();
        if (attachmentTypeArray instanceof IGun) {
            IGun iGun = (IGun)attachmentTypeArray;
            for (AttachmentType type : AttachmentType.values()) {
                IAttachment iAttachment;
                class_1799 attachment = iGun.getAttachment(gun, type);
                class_1792 class_17922 = attachment.method_7909();
                if (!(class_17922 instanceof IAttachment) || !(iAttachment = (IAttachment)class_17922).hasCustomLaserColor(attachment)) continue;
                this.colorMap.put(type, iAttachment.getLaserColor(attachment));
            }
            if (iGun.hasCustomLaserColor(gun)) {
                this.gunColor = iGun.getLaserColor(gun);
                this.applyGunColor = true;
            }
            this.gunSlotIndex = gunSlotIndex;
        }
    }

    public void write(class_2540 buf) {
        buf.method_34063(this.colorMap, class_2540::method_10817, class_2540::writeInt);
        buf.writeBoolean(this.applyGunColor);
        buf.writeInt(this.gunColor);
        buf.writeInt(this.gunSlotIndex);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        class_1661 inventory = player.method_31548();
        class_1799 gunItem = inventory.method_5438(this.gunSlotIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            for (Map.Entry<AttachmentType, Integer> entry : this.colorMap.entrySet()) {
                AttachmentType type = entry.getKey();
                int color = entry.getValue();
                class_1799 attachment = iGun.getAttachment(gunItem, type);
                class_1792 class_17922 = attachment.method_7909();
                if (!(class_17922 instanceof IAttachment)) continue;
                IAttachment iAttachment = (IAttachment)class_17922;
                iAttachment.setLaserColor(attachment, color);
            }
            if (this.applyGunColor) {
                iGun.setLaserColor(gunItem, this.gunColor);
            }
        }
    }
}

