/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.filter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.filter.IFilter;
import com.tacz.guns.resource.filter.LiteralFilter;
import com.tacz.guns.resource.filter.RegexFilter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class RecipeFilter {
    private final List<IFilter<class_2960>> whitelist = new ArrayList<IFilter<class_2960>>();
    private final List<IFilter<class_2960>> blacklist = new ArrayList<IFilter<class_2960>>();

    public void merge(RecipeFilter other) {
        this.whitelist.addAll(other.whitelist);
        this.blacklist.addAll(other.blacklist);
    }

    public boolean contains(class_2960 location) {
        boolean allowed = this.whitelist.isEmpty();
        for (IFilter<class_2960> filter : this.whitelist) {
            if (!filter.test(location)) continue;
            allowed = true;
            break;
        }
        for (IFilter<class_2960> filter : this.blacklist) {
            if (!filter.test(location)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public List<class_2960> filter(List<class_2960> input) {
        ArrayList<class_2960> output = new ArrayList<class_2960>();
        for (class_2960 location : input) {
            if (!this.contains(location)) continue;
            output.add(location);
        }
        return output;
    }

    public <T> List<T> filter(List<T> input, Function<T, class_2960> getter) {
        ArrayList<T> output = new ArrayList<T>();
        for (T entry : input) {
            if (!this.contains(getter.apply(entry))) continue;
            output.add(entry);
        }
        return output;
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeFilter>,
    JsonSerializer<RecipeFilter> {
        public RecipeFilter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray bl;
            RecipeFilter filter = new RecipeFilter();
            JsonArray wl = json.getAsJsonObject().getAsJsonArray("whitelist");
            if (wl != null) {
                this.loadFilters(wl, filter.whitelist);
            }
            if ((bl = json.getAsJsonObject().getAsJsonArray("blacklist")) != null) {
                this.loadFilters(bl, filter.blacklist);
            }
            return filter;
        }

        private void loadFilters(JsonArray array, @NotNull List<IFilter<class_2960>> list) {
            LiteralFilter.Builder<class_2960> builder = new LiteralFilter.Builder<class_2960>();
            for (JsonElement element : array) {
                if (element.isJsonPrimitive()) {
                    String entry = element.getAsString();
                    if (entry.startsWith("^")) {
                        try {
                            list.add(new RegexFilter(entry));
                        }
                        catch (PatternSyntaxException e) {
                            GunMod.LOGGER.error("Failed to parse regex filter: {}", (Object)entry, (Object)e);
                        }
                        continue;
                    }
                    class_2960 rl = class_2960.method_12829((String)entry);
                    if (rl == null) continue;
                    builder.add(rl);
                    continue;
                }
                throw new JsonParseException("Invalid recipe filter entry: " + String.valueOf(element));
            }
            list.add(builder.build());
        }

        public JsonElement serialize(RecipeFilter filter, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.add("whitelist", context.serialize(this.toList(filter.whitelist)));
            json.add("blacklist", context.serialize(this.toList(filter.blacklist)));
            return json;
        }

        private List<String> toList(List<IFilter<class_2960>> filter) {
            ArrayList<String> list = new ArrayList<String>();
            for (IFilter<class_2960> f : filter) {
                if (f instanceof LiteralFilter) {
                    LiteralFilter literalFilter = (LiteralFilter)f;
                    list.addAll(literalFilter.getSet().stream().map(class_2960::toString).toList());
                    continue;
                }
                if (!(f instanceof RegexFilter)) continue;
                RegexFilter regexFilter = (RegexFilter)f;
                list.add(regexFilter.getPattern().pattern());
            }
            return list;
        }
    }
}

