/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AttachmentsTagManager
extends class_4080<Map<class_2960, List<JsonElement>>>
implements INetworkCacheReloadListener {
    private final Map<class_2960, Set<String>> tags = Maps.newHashMap();
    private final Map<class_2960, Set<String>> allow_attachments = Maps.newHashMap();
    private final Gson gson = CommonAssetsManager.GSON;
    private final Marker marker = MarkerFactory.getMarker((String)"AllowTagManager");
    private final class_7654 fileToIdConverter = class_7654.method_45114((String)"tacz_tags/attachments");
    protected Map<class_2960, String> networkCache;
    public static final class_2960 ID = new class_2960("tacz", "attachments_tag_manager");

    @NotNull
    protected Map<class_2960, List<JsonElement>> prepare(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<class_2960, List<JsonElement>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        this.tags.clear();
        this.allow_attachments.clear();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, List<JsonElement>> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();
            ArrayList<String> temp = new ArrayList<String>();
            for (JsonElement element : entry.getValue()) {
                try {
                    List<String> data = this.parseJson(element);
                    if (data == null) continue;
                    if (data.stream().anyMatch(Objects::isNull)) {
                        throw new JsonParseException("Null value found in JSON data");
                    }
                    temp.addAll(data);
                }
                catch (JsonParseException e) {
                    GunMod.LOGGER.error(this.marker, "Failed to parse data file {}", (Object)id, (Object)e);
                }
            }
            if (id.method_12832().startsWith("allow_attachments/") && id.method_12832().length() > 18) {
                class_2960 gunId = id.method_45136(id.method_12832().substring(18));
                this.allow_attachments.computeIfAbsent(gunId, v -> Sets.newHashSet()).addAll(temp);
            } else {
                this.tags.computeIfAbsent(id, v -> Sets.newHashSet()).addAll(temp);
            }
            builder.put((Object)entry.getKey(), (Object)this.gson.toJson(temp));
        }
        this.networkCache = builder.build();
    }

    private List<String> parseJson(JsonElement element) {
        return (List)this.gson.fromJson(element, (TypeToken)new TypeToken<List<String>>(){});
    }

    @Override
    public Map<class_2960, String> getNetworkCache() {
        return this.networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.ATTACHMENT_TAGS;
    }

    public Set<String> getAttachmentTags(class_2960 registryName) {
        return this.tags.get(registryName);
    }

    public Set<String> getAllowAttachmentTags(class_2960 registryName) {
        return this.allow_attachments.get(registryName);
    }

    public class_2960 getFabricId() {
        return null;
    }
}

