/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ExtraMovementModifier
implements IAttachmentModifier<MoveSpeed, MoveSpeed> {
    public static final String ID = GunProperties.MOVE_SPEED.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<MoveSpeed> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        MoveSpeed moveSpeed = data.getMoveSpeed();
        return new ExtraSpeedJsonProperty(moveSpeed);
    }

    @Override
    public CacheValue<MoveSpeed> initCache(class_1799 gunItem, GunData gunData) {
        return new CacheValue<MoveSpeed>(gunData.getMoveSpeed());
    }

    @Override
    public void eval(List<MoveSpeed> modifiers, CacheValue<MoveSpeed> cache) {
        cache.setValue(MoveSpeed.of(cache.getValue(), modifiers));
    }

    public static class Data {
        @SerializedName(value="movement_speed")
        @Nullable
        private MoveSpeed moveSpeed = null;

        @Nullable
        public MoveSpeed getMoveSpeed() {
            return this.moveSpeed;
        }
    }

    public static class ExtraSpeedJsonProperty
    extends JsonProperty<MoveSpeed> {
        public ExtraSpeedJsonProperty(MoveSpeed value) {
            super(value);
        }

        @Override
        public void initComponents() {
            MoveSpeed speed = (MoveSpeed)this.getValue();
            if (speed == null) {
                return;
            }
            this.resolveComponent(speed.getBaseMultiplier(), "movement_speed");
            this.resolveComponent(speed.getAimMultiplier(), "aim_speed");
            this.resolveComponent(speed.getReloadMultiplier(), "reload_speed");
        }

        private void resolveComponent(float amount, String key) {
            if (amount > 0.0f) {
                this.components.add(class_2561.method_43471((String)String.format("tooltip.tacz.attachment.%s.increase", key)).method_27692(class_124.field_1060));
            } else if (amount < 0.0f) {
                this.components.add(class_2561.method_43471((String)String.format("tooltip.tacz.attachment.%s.decrease", key)).method_27692(class_124.field_1061));
            }
        }
    }
}

