/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerMelee;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class LocalPlayerMelee {
    public static final String MELEE_STOCK_ANIMATION = "melee_stock";
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerMelee(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void melee() {
        if (this.data.clientStateLock) {
            return;
        }
        class_1799 mainHandItem = this.player.method_6047();
        class_1792 class_17922 = mainHandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        GunDisplayInstance display = TimelessAPI.getGunDisplay(mainHandItem).orElse(null);
        if (display == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        class_2960 muzzleId = iGun.getAttachmentId(mainHandItem, AttachmentType.MUZZLE);
        MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
        if (muzzleMeleeData != null) {
            this.doMuzzleMelee(display);
            return;
        }
        class_2960 stockId = iGun.getAttachmentId(mainHandItem, AttachmentType.STOCK);
        MeleeData stockMeleeData = this.getMeleeData(stockId);
        if (stockMeleeData != null) {
            this.doStockMelee(display);
            return;
        }
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
            if (defaultMeleeData == null) {
                return;
            }
            String animationType = defaultMeleeData.getAnimationType();
            if (MELEE_STOCK_ANIMATION.equals(animationType)) {
                this.doStockMelee(display);
                return;
            }
            this.doPushMelee(display);
        });
    }

    private boolean prepareMelee() {
        this.data.lockState(operator -> operator.getSynMeleeCoolDown() > 0L);
        GunMeleeEvent gunMeleeEvent = new GunMeleeEvent((class_1309)this.player, this.player.method_6047(), LogicalSide.CLIENT);
        ((GunMeleeEvent.Callback)GunMeleeEvent.CALLBACK.invoker()).post(gunMeleeEvent);
        return !gunMeleeEvent.isCanceled();
    }

    private void doMuzzleMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleeBayonetSound((class_1309)this.player, display);
            ClientPlayNetworking.send((class_8710)ClientMessagePlayerMelee.INSTANCE);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_muzzle");
            }
        }
    }

    private void doStockMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleeStockSound((class_1309)this.player, display);
            ClientPlayNetworking.send((class_8710)ClientMessagePlayerMelee.INSTANCE);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_stock");
            }
        }
    }

    private void doPushMelee(GunDisplayInstance display) {
        if (this.prepareMelee()) {
            SoundPlayManager.playMeleePushSound((class_1309)this.player, display);
            ClientPlayNetworking.send((class_8710)ClientMessagePlayerMelee.INSTANCE);
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger("bayonet_push");
            }
        }
    }

    @Nullable
    private MeleeData getMeleeData(class_2960 attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getClientAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

