/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public final class GunPropertyDiagrams {
    public static int getHidePropertyButtonYOffset() {
        int[] startYOffset = new int[]{49};
        AttachmentPropertyManager.getModifiers().forEach((key, value) -> {
            startYOffset[0] = startYOffset[0] + value.getDiagramsDataSize() * 10;
        });
        return startYOffset[0];
    }

    public static void draw(class_332 graphics, class_327 font, int x, int y) {
        graphics.method_25294(x, y, x + 288, y + GunPropertyDiagrams.getHidePropertyButtonYOffset() - 11, -1356717534);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 gunItem = player.method_6047();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((class_1309)player).getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            GunData gunData = index.getGunData();
            FireMode fireMode = iGun.getFireMode(gunItem);
            int barStartX = x + 83;
            int barMaxWidth = 120;
            int barEndX = barStartX + barMaxWidth;
            int barBackgroundColor = -16777216;
            int barBaseColor = -1;
            int barPositivelyColor = -11141291;
            int barNegativeColor = -43691;
            int fontColor = 0xCCCCCC;
            int nameTextStartX = x + 5;
            int valueTextStartX = x + 210;
            int[] yOffset = new int[]{y + 5};
            class_5250 fireModeText = class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.fire_mode");
            if (fireMode == FireMode.AUTO) {
                fireModeText.method_10852((class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.auto"));
            } else if (fireMode == FireMode.SEMI) {
                fireModeText.method_10852((class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.semi"));
            } else if (fireMode == FireMode.BURST) {
                fireModeText.method_10852((class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.burst"));
            } else {
                fireModeText.method_10852((class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.unknown"));
            }
            graphics.method_51439(font, (class_2561)fireModeText, nameTextStartX + 12, yOffset[0], fontColor, false);
            yOffset[0] = yOffset[0] + 10;
            if (iGun.useInventoryAmmo(gunItem)) {
                graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.ammo_capacity"), nameTextStartX, yOffset[0], fontColor, false);
                graphics.method_25294(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.method_25294(barStartX, yOffset[0] + 2, barStartX + barMaxWidth, yOffset[0] + 6, barBaseColor);
                graphics.method_51439(font, (class_2561)class_2561.method_43470((String)"INV"), valueTextStartX, yOffset[0], fontColor, false);
            } else {
                int barrelBulletAmount = iGun.hasBulletInBarrel(gunItem) && index.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
                int ammoAmount = gunData.getAmmoAmount() + barrelBulletAmount;
                double ammoAmountPercent = Math.min((double)ammoAmount / 100.0, 1.0);
                int ammoLength = (int)((double)barStartX + (double)barMaxWidth * ammoAmountPercent);
                int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData()) + barrelBulletAmount;
                int addAmmoCount = Math.max(maxAmmoCount - ammoAmount, 0);
                int addAmmoCountLength = (int)((double)(barMaxWidth * addAmmoCount) / 100.0);
                graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.ammo_capacity"), nameTextStartX, yOffset[0], fontColor, false);
                graphics.method_25294(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.method_25294(barStartX, yOffset[0] + 2, ammoLength, yOffset[0] + 6, barBaseColor);
                if (addAmmoCount > 0) {
                    int barRight = Math.min(ammoLength + addAmmoCountLength, barEndX);
                    graphics.method_25294(ammoLength, yOffset[0] + 2, barRight, yOffset[0] + 6, barPositivelyColor);
                    graphics.method_51433(font, String.format("%d \u00a7a(+%d)", ammoAmount, addAmmoCount), valueTextStartX, yOffset[0], fontColor, false);
                } else {
                    graphics.method_51433(font, String.format("%d", ammoAmount), valueTextStartX, yOffset[0], fontColor, false);
                }
            }
            yOffset[0] = yOffset[0] + 10;
            float sprintTime = gunData.getSprintTime();
            double sprintTimePercent = class_3532.method_15350((double)((double)sprintTime / 0.5), (double)0.0, (double)1.0);
            int sprintLength = (int)((double)barStartX + (double)barMaxWidth * sprintTimePercent);
            String sprintValueText = String.format("%.2fs", Float.valueOf(sprintTime));
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_refit.property_diagrams.sprint_time"), nameTextStartX, yOffset[0], fontColor, false);
            graphics.method_25294(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
            graphics.method_25294(barStartX, yOffset[0] + 2, sprintLength, yOffset[0] + 6, barBaseColor);
            graphics.method_51433(font, sprintValueText, valueTextStartX, yOffset[0], fontColor, false);
            yOffset[0] = yOffset[0] + 10;
            AttachmentPropertyManager.getModifiers().forEach((key, value) -> value.getPropertyDiagramsData(gunItem, gunData, cacheProperty).forEach(data -> {
                double defaultPercent = data.defaultPercent();
                double modifierPercent = data.modifierPercent();
                double modifier = data.modifier().doubleValue();
                String titleKey = data.titleKey();
                String positivelyString = data.positivelyString();
                String negativeString = data.negativeString();
                String defaultString = data.defaultString();
                boolean positivelyBetter = data.positivelyBetter();
                defaultPercent = class_3532.method_15350((double)defaultPercent, (double)0.0, (double)1.0);
                int defaultLength = (int)((double)barStartX + (double)barMaxWidth * defaultPercent);
                int modifierLength = class_3532.method_15340((int)(defaultLength + (int)((double)barMaxWidth * modifierPercent)), (int)barStartX, (int)barEndX);
                graphics.method_51439(font, (class_2561)class_2561.method_43471((String)titleKey), nameTextStartX, yOffset[0], fontColor, false);
                graphics.method_25294(barStartX, yOffset[0] + 2, barEndX, yOffset[0] + 6, barBackgroundColor);
                graphics.method_25294(barStartX, yOffset[0] + 2, defaultLength, yOffset[0] + 6, barBaseColor);
                if (modifier > 0.0) {
                    int barColor = positivelyBetter ? barPositivelyColor : barNegativeColor;
                    graphics.method_25294(defaultLength, yOffset[0] + 2, modifierLength, yOffset[0] + 6, barColor);
                    graphics.method_51433(font, positivelyString, valueTextStartX, yOffset[0], fontColor, false);
                } else if (modifier < 0.0) {
                    int barColor = positivelyBetter ? barNegativeColor : barPositivelyColor;
                    graphics.method_25294(modifierLength, yOffset[0] + 2, defaultLength, yOffset[0] + 6, barColor);
                    graphics.method_51433(font, negativeString, valueTextStartX, yOffset[0], fontColor, false);
                } else {
                    graphics.method_51433(font, defaultString, valueTextStartX, yOffset[0], fontColor, false);
                }
                yOffset[0] = yOffset[0] + 10;
            }));
        });
    }
}

