/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class GunHudOverlay {
    private static final class_2960 SEMI = class_2960.method_60655((String)"tacz", (String)"textures/hud/fire_mode_semi.png");
    private static final class_2960 AUTO = class_2960.method_60655((String)"tacz", (String)"textures/hud/fire_mode_auto.png");
    private static final class_2960 BURST = class_2960.method_60655((String)"tacz", (String)"textures/hud/fire_mode_burst.png");
    private static final class_2960 HEATBAR = class_2960.method_60655((String)"tacz", (String)"textures/hud/heat_bar.png");
    private static final class_2960 HEATBASE = class_2960.method_60655((String)"tacz", (String)"textures/hud/heat_base.png");
    private static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    private static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static long checkAmmoTimestamp = -1L;
    private static int cacheMaxAmmoCount = 0;
    private static int cacheInventoryAmmoCount = 0;
    private static final int MAX_AMMO_COUNT = 9999;

    public static void render(class_332 graphics, class_9779 deltaTracker) {
        String inventoryAmmoCountText;
        boolean overheatLocked;
        int width = graphics.method_51421();
        int height = graphics.method_51443();
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        boolean useInventoryAmmo = iGun.useInventoryAmmo(stack);
        boolean useDummyAmmo = iGun.useDummyAmmo(stack);
        boolean bl = overheatLocked = gunData.hasHeatData() && iGun.isOverheatLocked(stack);
        int ammoCount = useInventoryAmmo ? cacheInventoryAmmoCount + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0) : iGun.getCurrentAmmoCount(stack) + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        int ammoCountColor = (double)(ammoCount = Math.min(ammoCount, 9999)) < (double)cacheMaxAmmoCount * 0.25 && ammoCount < 10 || overheatLocked ? 0xFF5555 : (useInventoryAmmo && useDummyAmmo ? 0x55FFFF : (useInventoryAmmo ? 0xFFFF55 : 0xFFFFFF));
        int inventoryAmmoCountColor = !useInventoryAmmo && useDummyAmmo ? 0x55FFFF : 0xAAAAAA;
        String currentAmmoCountText = display.getAmmoCountStyle() == AmmoCountStyle.PERCENT ? CURRENT_AMMO_FORMAT_PERCENT.format((float)ammoCount / (cacheMaxAmmoCount == 0 ? 1.0f : (float)cacheMaxAmmoCount)) : CURRENT_AMMO_FORMAT.format(ammoCount);
        String string = inventoryAmmoCountText = useInventoryAmmo ? "" : INVENTORY_AMMO_FORMAT.format(cacheInventoryAmmoCount);
        if (!useInventoryAmmo && gunData.getReloadData().isInfinite()) {
            inventoryAmmoCountText = "\u221e";
        }
        GunHudOverlay.handleCacheCount(player, stack, gunData, iGun, useInventoryAmmo);
        graphics.method_25294(width - 75, height - 43, width - 74, height - 25, -1);
        class_4587 poseStack = graphics.method_51448();
        class_327 font = mc.field_1772;
        poseStack.method_22903();
        poseStack.method_22905(1.5f, 1.5f, 1.0f);
        graphics.method_51433(font, currentAmmoCountText, (int)((float)(width - 70) / 1.5f), (int)((float)(height - 43) / 1.5f), ammoCountColor, false);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22905(0.8f, 0.8f, 1.0f);
        graphics.method_51433(font, inventoryAmmoCountText, (int)(((float)(width - 68) + (float)mc.field_1772.method_1727(currentAmmoCountText) * 1.5f) / 0.8f), (int)((float)(height - 43) / 0.8f), inventoryAmmoCountColor, false);
        poseStack.method_22909();
        String minecraftVersion = class_155.method_16673().method_48019();
        String modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("tacz").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 1.0f);
        graphics.method_25303(font, debugInfo, (int)((float)(width - 70) / 0.5f), (int)(((float)height - 29.0f) / 0.5f), -5592406);
        poseStack.method_22909();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_2960 hudTexture = display.getHUDTexture();
        @Nullable class_2960 hudEmptyTexture = display.getHudEmptyTexture();
        if (ammoCount <= 0 || overheatLocked) {
            if (hudEmptyTexture == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                hudTexture = hudEmptyTexture;
            }
        }
        graphics.method_25290(hudTexture, width - 117, height - 44, 0.0f, 0.0f, 39, 13, 39, 13);
        FireMode fireMode = IGun.getMainHandFireMode((class_1309)player);
        class_2960 fireModeTexture = switch (fireMode) {
            case FireMode.AUTO -> AUTO;
            case FireMode.BURST -> BURST;
            default -> SEMI;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(fireModeTexture, (int)((double)width - 68.5 + (double)mc.field_1772.method_1727(currentAmmoCountText) * 1.5), height - 38, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    private static void handleCacheCount(class_746 player, class_1799 stack, GunData gunData, IGun iGun, boolean useInventoryAmmo) {
        if (System.currentTimeMillis() - checkAmmoTimestamp > 50L) {
            checkAmmoTimestamp = System.currentTimeMillis();
            cacheMaxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(stack, gunData);
            if (IGunOperator.fromLivingEntity((class_1309)player).needCheckAmmo()) {
                if (iGun.useDummyAmmo(stack)) {
                    cacheInventoryAmmoCount = iGun.getDummyAmmoAmount(stack);
                } else {
                    GunHudOverlay.handleInventoryAmmo(stack, player.method_31548());
                }
            } else {
                cacheInventoryAmmoCount = 9999;
            }
            if (useInventoryAmmo) {
                iGun.setCurrentAmmoCount(stack, cacheInventoryAmmoCount);
            }
        }
    }

    private static void handleInventoryAmmo(class_1799 stack, class_1661 inventory) {
        cacheInventoryAmmoCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            class_1799 inventoryItem = inventory.method_5438(i);
            class_1792 class_17922 = inventoryItem.method_7909();
            if (class_17922 instanceof IAmmo && (iAmmo = (IAmmo)class_17922).isAmmoOfGun(stack, inventoryItem)) {
                cacheInventoryAmmoCount += inventoryItem.method_7947();
            }
            if (!((class_17922 = inventoryItem.method_7909()) instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)class_17922).isAmmoBoxOfGun(stack, inventoryItem)) continue;
            if (iAmmoBox.isAllTypeCreative(inventoryItem) || iAmmoBox.isCreative(inventoryItem)) {
                cacheInventoryAmmoCount = 9999;
                return;
            }
            cacheInventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryItem);
        }
    }
}

