/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.init;

import com.tacz.guns.api.client.other.ThirdPersonManager;
import com.tacz.guns.client.gui.overlay.GunHudOverlay;
import com.tacz.guns.client.gui.overlay.HeatBarOverlay;
import com.tacz.guns.client.gui.overlay.InteractKeyTextOverlay;
import com.tacz.guns.client.gui.overlay.KillAmountOverlay;
import com.tacz.guns.client.input.AimKey;
import com.tacz.guns.client.input.ConfigKey;
import com.tacz.guns.client.input.CrawlKey;
import com.tacz.guns.client.input.FireSelectKey;
import com.tacz.guns.client.input.InspectKey;
import com.tacz.guns.client.input.InteractKey;
import com.tacz.guns.client.input.MeleeKey;
import com.tacz.guns.client.input.RefitKey;
import com.tacz.guns.client.input.ReloadKey;
import com.tacz.guns.client.input.ShootKey;
import com.tacz.guns.client.input.ZoomKey;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.tooltip.ClientAmmoBoxTooltip;
import com.tacz.guns.client.tooltip.ClientAttachmentItemTooltip;
import com.tacz.guns.client.tooltip.ClientBlockItemTooltip;
import com.tacz.guns.client.tooltip.ClientGunTooltip;
import com.tacz.guns.compat.controllable.ControllableCompat;
import com.tacz.guns.compat.immediatelyfast.ImmediatelyFastCompat;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.compat.zoomify.ZoomifyCompat;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.inventory.tooltip.AmmoBoxTooltip;
import com.tacz.guns.inventory.tooltip.AttachmentItemTooltip;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.item.AmmoBoxItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import net.minecraft.class_5272;

@Environment(value=EnvType.CLIENT)
public class ClientSetupEvent {
    public static void init() {
        ClientSetupEvent.registerKeyMappings();
        ClientSetupEvent.registerClientTooltips();
        ClientSetupEvent.registerGuiOverlays();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> ClientSetupEvent.onClientSetup());
        ClientSetupEvent.onClientResourceReload();
    }

    public static void registerKeyMappings() {
        ClientSetupEvent.registerKeyBinding(InspectKey.INSPECT_KEY);
        ClientSetupEvent.registerKeyBinding(ReloadKey.RELOAD_KEY);
        ClientSetupEvent.registerKeyBinding(ShootKey.SHOOT_KEY);
        ClientSetupEvent.registerKeyBinding(InteractKey.INTERACT_KEY);
        ClientSetupEvent.registerKeyBinding(FireSelectKey.FIRE_SELECT_KEY);
        ClientSetupEvent.registerKeyBinding(AimKey.AIM_KEY);
        ClientSetupEvent.registerKeyBinding(CrawlKey.CRAWL_KEY);
        ClientSetupEvent.registerKeyBinding(RefitKey.REFIT_KEY);
        ClientSetupEvent.registerKeyBinding(ZoomKey.ZOOM_KEY);
        ClientSetupEvent.registerKeyBinding(MeleeKey.MELEE_KEY);
        ClientSetupEvent.registerKeyBinding(ConfigKey.OPEN_CONFIG_KEY);
    }

    private static void registerKeyBinding(class_304 keyMapping) {
        KeyBindingHelper.registerKeyBinding((class_304)keyMapping);
    }

    public static void registerClientTooltips() {
        TooltipComponentCallback.EVENT.register(tooltip -> {
            if (tooltip instanceof GunTooltip) {
                GunTooltip gunTooltip = (GunTooltip)tooltip;
                return new ClientGunTooltip(gunTooltip);
            }
            if (tooltip instanceof AmmoBoxTooltip) {
                AmmoBoxTooltip ammoBoxTooltip = (AmmoBoxTooltip)tooltip;
                return new ClientAmmoBoxTooltip(ammoBoxTooltip);
            }
            if (tooltip instanceof AttachmentItemTooltip) {
                AttachmentItemTooltip attachmentItemTooltip = (AttachmentItemTooltip)tooltip;
                return new ClientAttachmentItemTooltip(attachmentItemTooltip);
            }
            if (tooltip instanceof BlockItemTooltip) {
                BlockItemTooltip blockItemTooltip = (BlockItemTooltip)tooltip;
                return new ClientBlockItemTooltip(blockItemTooltip);
            }
            return null;
        });
    }

    public static void registerGuiOverlays() {
        HudRenderCallback.EVENT.register(GunHudOverlay::render);
        HudRenderCallback.EVENT.register(HeatBarOverlay::render);
        HudRenderCallback.EVENT.register(InteractKeyTextOverlay::render);
        HudRenderCallback.EVENT.register(KillAmountOverlay::render);
    }

    public static void onClientSetup() {
        ThirdPersonManager.registerDefault();
        ColorProviderRegistry.ITEM.register(AmmoBoxItem::getColor, (Object[])new class_1935[]{ModItems.AMMO_BOX});
        class_5272.method_27879((class_1792)ModItems.AMMO_BOX, (class_2960)AmmoBoxItem.PROPERTY_NAME, AmmoBoxItem::getStatue);
        ShoulderSurfingCompat.init();
        ControllableCompat.init();
        ZoomifyCompat.init();
        ImmediatelyFastCompat.init();
    }

    public static void onClientResourceReload() {
        PlayerAnimatorCompat.init();
        ClientAssetsManager.INSTANCE.reloadAndRegister(arg_0 -> ((ResourceManagerHelper)ResourceManagerHelper.get((class_3264)class_3264.field_14188)).registerReloadListener(arg_0));
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorCompat.registerReloadListener(arg_0 -> ((ResourceManagerHelper)ResourceManagerHelper.get((class_3264)class_3264.field_14188)).registerReloadListener(arg_0));
        }
    }
}

