/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.pojo.TransformScale;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_1047;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import org.joml.Vector3f;

public class AmmoItemRenderer
extends class_756 {
    private static final SlotModel SLOT_AMMO_MODEL = new SlotModel();
    public static final Supplier<AmmoItemRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 client = class_310.method_1551();
        return new AmmoItemRenderer(client.method_31975(), client.method_31974());
    });

    public AmmoItemRenderer(class_824 pBlockEntityRenderDispatcher, class_5599 pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, class_4587 poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.method_22904(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.method_22907(class_7833.field_40713.rotation(t.xRot));
            poseStack.method_22907(class_7833.field_40715.rotation(t.yRot));
            poseStack.method_22907(class_7833.field_40717.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.method_46416(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.method_46416(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.method_22904(0.0, -1.5, 0.0);
    }

    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IAmmo)) {
            return;
        }
        IAmmo iAmmo = (IAmmo)class_17922;
        class_2960 ammoId = iAmmo.getAmmoId(stack);
        poseStack.method_22903();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresentOrElse(ammoIndex -> {
            BedrockAmmoModel ammoModel = ammoIndex.getAmmoModel();
            class_2960 modelTexture = ammoIndex.getModelTextureLocation();
            if (transformType == class_811.field_4317 || ammoModel == null || modelTexture == null) {
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)ammoIndex.getSlotTextureLocation()));
                SLOT_AMMO_MODEL.method_60879(poseStack, buffer, pPackedLight, pPackedOverlay);
                return;
            }
            poseStack.method_22904(0.5, 2.0, 0.5);
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            this.applyPositioningTransform(transformType, ammoIndex.getTransform().getScale(), ammoModel, poseStack);
            this.applyScaleTransform(transformType, ammoIndex.getTransform().getScale(), poseStack);
            class_1921 renderType = class_1921.method_23576((class_2960)modelTexture);
            ammoModel.render(poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)class_1047.method_4539()));
            SLOT_AMMO_MODEL.method_60879(poseStack, buffer, pPackedLight, pPackedOverlay);
        });
        poseStack.method_22909();
    }

    private void applyPositioningTransform(class_811 transformType, TransformScale scale, BedrockAmmoModel model, class_4587 poseStack) {
        switch (transformType) {
            case field_4319: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case field_4318: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case field_4320: 
            case field_4323: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private void applyScaleTransform(class_811 transformType, TransformScale scale, class_4587 poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case field_4319: {
                vector3f = scale.getFixed();
                break;
            }
            case field_4318: {
                vector3f = scale.getGround();
                break;
            }
            case field_4320: 
            case field_4323: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.method_22904(0.0, 1.5, 0.0);
            poseStack.method_22905(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.method_22904(0.0, -1.5, 0.0);
        }
    }
}

