/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import cn.sh1rocu.tacz.api.event.ViewportEvent;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.client.animation.statemachine.ItemAnimationStateContext;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.util.math.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AnimateGeoItemRenderer<M extends BedrockAnimatedModel, CTX extends ItemAnimationStateContext>
extends class_756 {
    @Nullable
    protected LuaAnimationStateMachine<CTX> stateMachine;
    protected M model;
    public class_2960 textureLocation;

    public AnimateGeoItemRenderer() {
        super(class_310.method_1551().method_31975(), class_310.method_1551().method_31974());
    }

    public void setModel(M model) {
        this.model = model;
    }

    public M getModel(class_1799 stack) {
        return this.model;
    }

    @Nullable
    public LuaAnimationStateMachine<CTX> getStateMachine(class_1799 stack) {
        return this.stateMachine;
    }

    public class_2960 getTextureLocation(class_1799 stack) {
        return this.textureLocation;
    }

    public class_1921 getRenderType(class_1799 stack) {
        return class_1921.method_23576((class_2960)this.getTextureLocation(stack));
    }

    public boolean needReInit(class_1799 stack) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return false;
        }
        return !stateMachine.isInitialized() && stateMachine.getExitingTime() < System.currentTimeMillis();
    }

    public abstract CTX initContext(class_1799 var1, class_1657 var2, float var3);

    public abstract void updateContext(CTX var1, class_1799 var2, class_1657 var3, float var4);

    public long getPutAwayTime(class_1799 stack) {
        return 0L;
    }

    public void tryInit(class_1799 stack, class_1657 player, float partialTick) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        if (stateMachine.isInitialized()) {
            stateMachine.exit();
        }
        stateMachine.setContext(this.initContext(stack, player, partialTick));
        stateMachine.initialize();
        stateMachine.trigger("draw");
    }

    public void tryExit(class_1799 stack, long putAwayTime) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> context.setPutAwayTime((float)putAwayTime / 1000.0f));
        if (stateMachine.isInitialized()) {
            stateMachine.trigger("put_away");
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            stateMachine.setExitingTime(putAwayTime + 50L);
        }
    }

    public void triggerAnimation(class_1799 stack, String input) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.trigger(input);
    }

    public void visualUpdate(class_1799 stack) {
        LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.visualUpdate();
    }

    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, class_746 player) {
        this.applyLevelCameraAnimation(event, stack, 1.0f);
    }

    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, float multiplier) {
        M model = this.getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf q = MathUtil.multiplyQuaternion(((BedrockAnimatedModel)model).getCameraAnimationObject().rotationQuaternion, multiplier);
        double yaw = Math.asin(2.0f * (q.w() * q.y() - q.x() * q.z()));
        double pitch = Math.atan2(2.0f * (q.w() * q.x() + q.y() * q.z()), 1.0f - 2.0f * (q.x() * q.x() + q.y() * q.y()));
        double roll = Math.atan2(2.0f * (q.w() * q.z() + q.x() * q.y()), 1.0f - 2.0f * (q.y() * q.y() + q.z() * q.z()));
        yaw = Math.toDegrees(yaw);
        pitch = Math.toDegrees(pitch);
        roll = Math.toDegrees(roll);
        event.setYaw((float)yaw + event.getYaw());
        event.setPitch((float)pitch + event.getPitch());
        event.setRoll((float)roll + event.getRoll());
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, class_746 player) {
        this.applyItemInHandCameraAnimation(event, stack, 1.0f);
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, float multiplier) {
        M model = this.getModel(stack);
        if (model == null) {
            return;
        }
        Quaternionf quaternion = MathUtil.multiplyQuaternion(((BedrockAnimatedModel)model).getCameraAnimationObject().rotationQuaternion, multiplier);
        class_4587 poseStack = event.getPoseStack();
        poseStack.method_22907(quaternion);
    }

    public void doExtraTransforms(class_4587 poseStack, M model, class_1799 stack) {
        AnimateGeoItemRenderer.applyFirstPersonPositioningTransform(poseStack, model, stack);
    }

    public void renderFirstPerson(class_746 player, class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource, int light, float partialTick) {
        M model = this.getModel(stack);
        if (model != null) {
            poseStack.method_22903();
            float xRotOffset = class_3532.method_16439((float)partialTick, (float)player.field_3914, (float)player.field_3916);
            float yRotOffset = class_3532.method_16439((float)partialTick, (float)player.field_3931, (float)player.field_3932);
            float xRot = player.method_5695(partialTick) - xRotOffset;
            float yRot = player.method_5705(partialTick) - yRotOffset;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xRot * -0.1f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot * -0.1f));
            BedrockPart rootNode = ((BedrockAnimatedModel)model).getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot * 0.05f));
            }
            poseStack.method_46416(0.0f, 1.5f, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            this.doExtraTransforms(poseStack, model, stack);
            LuaAnimationStateMachine<CTX> stateMachine = this.getStateMachine(stack);
            if (stateMachine != null) {
                stateMachine.processContextIfExist(context -> this.updateContext(context, stack, (class_1657)player, partialTick));
                stateMachine.update();
            }
            ((BedrockModel)model).render(poseStack, ctx, this.getRenderType(stack), light, class_4608.field_21444);
            ((BedrockAnimatedModel)model).cleanAnimationTransform();
            poseStack.method_22909();
        }
    }

    @ParametersAreNonnullByDefault
    public void method_3166(class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource, int light, int overlay) {
        if (ctx.method_29998()) {
            return;
        }
        M model = this.getModel(stack);
        if (model != null) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            ((BedrockModel)model).render(poseStack, ctx, class_1921.method_23576((class_2960)this.getTextureLocation(stack)), light, overlay);
            poseStack.method_22909();
        }
    }

    @Nonnull
    public static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; --i) {
                BedrockPart part = nodePath.get(i);
                matrix4f.rotate((Quaternionfc)class_7833.field_40713.rotation(part.xRot));
                matrix4f.rotate((Quaternionfc)class_7833.field_40715.rotation(part.yRot));
                matrix4f.rotate((Quaternionfc)class_7833.field_40717.rotation(part.zRot));
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
                    continue;
                }
                matrix4f.translate(-part.x / 16.0f, 1.5f - part.y / 16.0f, -part.z / 16.0f);
            }
        }
        return matrix4f;
    }

    public static void applyFirstPersonPositioningTransform(class_4587 poseStack, BedrockAnimatedModel model, class_1799 stack) {
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        List<BedrockPart> idleNodePath = model.getIdleSightPath();
        Matrix4f idleViewMatrix = AnimateGeoItemRenderer.getPositioningNodeInverse(idleNodePath);
        MathUtil.applyMatrixLerp(transformMatrix, idleViewMatrix, transformMatrix, 1.0f);
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_34425(transformMatrix);
        poseStack.method_46416(0.0f, -1.5f, 0.0f);
    }
}

