/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.custom.AdsModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class LivingEntityAim {
    private final class_1309 shooter;
    private final ShooterDataHolder data;

    public LivingEntityAim(class_1309 shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void aim(boolean isAim) {
        this.data.isAiming = isAim;
    }

    public void zoom() {
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 scopeId = iGun.getAttachmentId(currentGunItem, AttachmentType.SCOPE);
        class_2487 scopeTag = iGun.getAttachmentTag(currentGunItem, AttachmentType.SCOPE);
        if (!DefaultAssets.isEmptyAttachmentId(scopeId) && scopeTag != null) {
            TimelessAPI.getCommonAttachmentIndex(scopeId).ifPresent(index -> {
                int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(scopeTag);
                ++zoomNumber;
                AttachmentItemDataAccessor.setZoomNumberToTag(scopeTag, zoomNumber %= 0x7FFFFFFE);
            });
        }
        iGun.setAttachmentTag(currentGunItem, AttachmentType.SCOPE, scopeTag);
    }

    public void tickAimingProgress() {
        class_1792 class_17922;
        if (this.data.currentGunItem == null || !((class_17922 = this.data.currentGunItem.get().method_7909()) instanceof IGun)) {
            this.data.aimingProgress = 0.0f;
            this.data.aimingTimestamp = System.currentTimeMillis();
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_2960 gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            this.data.aimingProgress = 0.0f;
            return;
        }
        GunData gunData = gunIndexOptional.get().getGunData();
        float aimTime = gunData.getAimTime();
        if (this.data.cacheProperty != null) {
            aimTime = ((Float)this.data.cacheProperty.getCache(AdsModifier.ID)).floatValue();
        }
        aimTime = Math.max(0.0f, aimTime);
        float alphaProgress = (float)(System.currentTimeMillis() - this.data.aimingTimestamp + 1L) / (aimTime * 1000.0f);
        if (this.data.isAiming) {
            this.data.aimingProgress += alphaProgress;
            if (this.data.aimingProgress > 1.0f) {
                this.data.aimingProgress = 1.0f;
            }
        } else {
            this.data.aimingProgress -= alphaProgress;
            if (this.data.aimingProgress < 0.0f) {
                this.data.aimingProgress = 0.0f;
            }
        }
        this.data.aimingTimestamp = System.currentTimeMillis();
    }

    public void tickSprint() {
        IGunOperator operator = IGunOperator.fromLivingEntity(this.shooter);
        ReloadState reloadState = operator.getSynReloadState();
        if (this.data.isAiming || reloadState.getStateType().isReloading() && !reloadState.getStateType().isReloadFinishing()) {
            this.shooter.method_5728(false);
        }
        if (this.data.sprintTimestamp == -1L) {
            this.data.sprintTimestamp = System.currentTimeMillis();
        }
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 gunItem = this.data.currentGunItem.get();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem)).ifPresentOrElse(gunIndex -> {
            float gunSprintTime = gunIndex.getGunData().getSprintTime();
            if (this.shooter.method_5624() && !this.shooter.method_18276()) {
                this.data.sprintTimeS += (float)(System.currentTimeMillis() - this.data.sprintTimestamp) / 1000.0f;
                if (this.data.sprintTimeS > gunSprintTime) {
                    this.data.sprintTimeS = gunSprintTime;
                }
            } else {
                this.data.sprintTimeS -= (float)(System.currentTimeMillis() - this.data.sprintTimestamp) / 1000.0f;
                if (this.data.sprintTimeS < 0.0f) {
                    this.data.sprintTimeS = 0.0f;
                }
            }
        }, () -> {
            this.data.sprintTimeS = 0.0f;
        });
        this.data.sprintTimestamp = System.currentTimeMillis();
    }
}

