/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandler;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.util.LuaEntityAccessor;
import com.tacz.guns.api.util.LuaNbtAccessor;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFire;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.AttachmentDataUtils;
import com.tacz.guns.util.CycleTaskHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class ModernKineticGunScriptAPI {
    public static String MARKER = "ScriptAPI";
    private class_1309 shooter;
    private ShooterDataHolder dataHolder;
    private class_1799 itemStack;
    private AbstractGunItem abstractGunItem;
    private CommonGunIndex gunIndex;
    private class_2960 gunId;
    private class_2960 gunDisplayId;
    private Supplier<Float> pitchSupplier;
    private Supplier<Float> yawSupplier;
    private LuaNbtAccessor nbtUtil;
    private LuaEntityAccessor entityAccessor;

    public LuaValue getCachedProperty(String id) {
        GunProperty<?> property = GunProperties.all().get(id);
        if (property == null) {
            throw new LuaError("unknown gun property: " + id);
        }
        AttachmentCacheProperty cache = IGunOperator.fromLivingEntity(this.shooter).getCacheProperty();
        if (cache == null) {
            return LuaValue.NIL;
        }
        return CoerceJavaToLua.coerce(cache.getCache(id));
    }

    public void shootOnce(boolean consumeAmmo) {
        GunData gunData = this.gunIndex.getGunData();
        BulletData bulletData = this.gunIndex.getBulletData();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.shooter);
        AttachmentCacheProperty cacheProperty = gunOperator.getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        float heatInaccuracy = 1.0f;
        if (this.hasHeatData()) {
            GunHeatData heatData = Objects.requireNonNull(this.gunIndex.getGunData().getHeatData());
            float heatMax = this.modifyProperty("max_heat", Float.class, Float.valueOf(heatData.getHeatMax())).floatValue();
            float heatPercentage = this.getHeatAmount() / heatMax;
            heatInaccuracy *= class_3532.method_16439((float)heatPercentage, (float)heatData.getMinInaccuracy(), (float)heatData.getMaxInaccuracy());
        }
        InaccuracyType inaccuracyType = InaccuracyType.getInaccuracyType(this.shooter);
        float unmodifiedInaccuracy = cacheProperty.getCache(GunProperties.INACCURACY).get((Object)inaccuracyType).floatValue() * heatInaccuracy;
        float inaccuracy = Math.max(0.0f, this.modifyProperty(GunProperties.INACCURACY, Float.class, Float.valueOf(unmodifiedInaccuracy)).floatValue());
        Pair silence = (Pair)cacheProperty.getCache(SilenceModifier.ID);
        int soundDistance = this.modifyProperty("sound_distance", Integer.class, (Integer)silence.left());
        boolean useSilenceSound = (Boolean)silence.right();
        float speed = this.modifyProperty(GunProperties.AMMO_SPEED, Float.class, cacheProperty.getCache(GunProperties.AMMO_SPEED)).floatValue();
        speed = (float)((double)speed * (Double)AmmoConfig.GLOBAL_BULLET_SPEED_MODIFIER.get());
        float processedSpeed = class_3532.method_15363((float)(speed / 20.0f), (float)0.0f, (float)Float.MAX_VALUE);
        int bulletAmount = this.modifyProperty("bullet_amount", Integer.class, Integer.valueOf(Math.max(bulletData.getBulletAmount(), 1)));
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        int cycles = this.modifyProperty("burst_count", Integer.class, Integer.valueOf(fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1));
        long period = this.modifyProperty("burst_shoot_interval", Long.class, Long.valueOf(fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L));
        CycleTaskHelper.addCycleTask(() -> {
            boolean fire;
            if (this.shooter.method_29504()) {
                return false;
            }
            if (!this.shooter.method_6047().equals(this.itemStack) || this.shooter.method_6047().method_7960()) {
                return false;
            }
            GunFireEvent gunFireEvent = new GunFireEvent(this.shooter, this.itemStack, LogicalSide.SERVER);
            ((GunFireEvent.Callback)GunFireEvent.CALLBACK.invoker()).post(gunFireEvent);
            boolean bl = fire = !gunFireEvent.isCanceled();
            if (fire) {
                NetworkHandler.sendToTrackingEntity(new ServerMessageGunFire(this.shooter.method_5628(), this.itemStack), (class_1297)this.shooter);
                if (consumeAmmo && !this.reduceAmmoOnce()) {
                    return false;
                }
                if (this.gunIndex.getGunData().hasHeatData()) {
                    Optional.ofNullable(this.gunIndex.getScript()).map(script -> this.checkFunction(script.get("handle_shoot_heat"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)this)), this::handleShootHeat);
                }
                float pitch = this.pitchSupplier != null ? this.pitchSupplier.get().floatValue() : this.shooter.method_36455();
                float yaw = this.yawSupplier != null ? this.yawSupplier.get().floatValue() : this.shooter.method_36454();
                class_1937 world = this.shooter.method_37908();
                class_2960 ammoId = gunData.getAmmoId();
                for (int i = 0; i < bulletAmount; ++i) {
                    boolean isTracer = bulletData.hasTracerAmmo() && gunOperator.nextBulletIsTracer(bulletData.getTracerCountInterval());
                    EntityKineticBullet bullet = new EntityKineticBullet(world, this.shooter, this.itemStack, ammoId, this.gunId, this.gunDisplayId, isTracer, gunData, bulletData);
                    bullet.applyShotgunDamageSpread(bulletAmount);
                    this.abstractGunItem.doBulletSpread(this.dataHolder, this.itemStack, this.shooter, bullet, i, processedSpeed, inaccuracy, pitch, yaw);
                    world.method_8649((class_1297)bullet);
                }
                if (soundDistance > 0) {
                    String soundId = useSilenceSound ? SoundManager.SILENCE_3P_SOUND : SoundManager.SHOOT_3P_SOUND;
                    SoundManager.sendSoundToNearby(this.shooter, soundDistance, this.gunId, this.gunDisplayId, soundId, 0.8f, 0.9f + this.shooter.method_59922().method_43057() * 0.125f);
                }
            }
            return true;
        }, period, cycles);
    }

    private <T> T modifyProperty(GunProperty<?> property, Class<T> type, T value) {
        return (T)this.abstractGunItem.modifyProperty(this.dataHolder, this.itemStack, this.shooter, property, type, value);
    }

    private <T> T modifyProperty(String id, Class<T> type, T value) {
        return (T)this.abstractGunItem.modifyProperty(this.dataHolder, this.itemStack, this.shooter, id, type, value);
    }

    public void handleShootHeat() {
        GunHeatData heatData = this.gunIndex.getGunData().getHeatData();
        if (heatData == null) {
            return;
        }
        float newHeat = Math.min(this.abstractGunItem.getHeatAmount(this.itemStack) + heatData.getHeatPerShot(), heatData.getHeatMax());
        this.abstractGunItem.setHeatAmount(this.itemStack, newHeat);
        if (newHeat >= heatData.getHeatMax()) {
            this.abstractGunItem.setOverheatLocked(this.itemStack, true);
        }
    }

    public boolean reduceAmmoOnce() {
        boolean noAmmo;
        Bolt boltType = TimelessAPI.getCommonGunIndex(this.abstractGunItem.getGunId(this.itemStack)).map(index -> index.getGunData().getBolt()).orElse(null);
        boolean hasAmmoInBarrel = this.abstractGunItem.hasBulletInBarrel(this.itemStack) && boltType != Bolt.OPEN_BOLT;
        boolean hasInventoryAmmo = this.abstractGunItem.hasInventoryAmmo(this.shooter, this.itemStack, this.isReloadingNeedConsumeAmmo());
        boolean bl = noAmmo = this.useInventoryAmmo() && !hasInventoryAmmo || !this.useInventoryAmmo() && this.abstractGunItem.getCurrentAmmoCount(this.itemStack) < 1;
        if (boltType == null) {
            return false;
        }
        if (boltType == Bolt.MANUAL_ACTION) {
            if (!hasAmmoInBarrel) {
                return false;
            }
            this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
            return true;
        }
        if (boltType == Bolt.CLOSED_BOLT) {
            if (!noAmmo) {
                if (this.useInventoryAmmo()) {
                    return this.consumeAmmoFromPlayer(1) == 1;
                }
                this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
                return true;
            }
            if (!hasAmmoInBarrel) {
                return false;
            }
            this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
            return true;
        }
        if (boltType == Bolt.OPEN_BOLT) {
            if (noAmmo) {
                return false;
            }
            if (this.useInventoryAmmo()) {
                return this.consumeAmmoFromPlayer(1) == 1;
            }
            this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
            return true;
        }
        return false;
    }

    public long getReloadTime() {
        if (this.dataHolder.reloadTimestamp == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.reloadTimestamp;
    }

    public long getBoltTime() {
        if (!this.dataHolder.isBolting) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.boltTimestamp;
    }

    public long getShootInterval() {
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        if (fireMode == FireMode.BURST) {
            long coolDown = (long)(this.gunIndex.getGunData().getBurstData().getMinInterval() * 1000.0);
            return Math.max(coolDown -= 5L, 0L);
        }
        long coolDown = this.gunIndex.getGunData().getShootInterval(this.shooter, fireMode, this.itemStack);
        return Math.max(coolDown -= 5L, 0L);
    }

    public long getLastShootTimestamp() {
        return this.dataHolder.lastShootTimestamp + this.dataHolder.baseTimestamp;
    }

    public void adjustShootInterval(long alpha) {
        this.dataHolder.shootTimestamp += alpha;
    }

    public void adjustReloadTime(long alpha) {
        this.dataHolder.reloadTimestamp -= alpha;
    }

    public void adjustBoltTime(long alpha) {
        this.dataHolder.boltTimestamp -= alpha;
    }

    public float getAimingProgress() {
        return this.dataHolder.aimingProgress;
    }

    public int getReloadStateType() {
        return this.dataHolder.reloadStateType.ordinal();
    }

    public int getFireMode() {
        return this.abstractGunItem.getFireMode(this.itemStack).ordinal();
    }

    public boolean isShootingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).consumesAmmoOrNot();
    }

    public boolean isReloadingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo();
    }

    public int getNeededAmmoAmount() {
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        return maxAmmoCount - currentAmmoCount;
    }

    public int getAmmoAmount() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public int getMaxAmmoCount() {
        return AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
    }

    public int getMagExtentLevel() {
        return AttachmentDataUtils.getMagExtendLevel(this.itemStack, this.gunIndex.getGunData());
    }

    public int consumeAmmoFromPlayer(int neededAmount) {
        if (this.useInventoryAmmo() && !this.isReloadingNeedConsumeAmmo()) {
            return neededAmount;
        }
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.findAndExtractDummyAmmo(this.itemStack, neededAmount);
        }
        return this.shooter.tacz$getItemHandler(null).map(cap -> this.abstractGunItem.findAndExtractInventoryAmmo((IItemHandler)cap, this.itemStack, neededAmount)).orElse(0);
    }

    public boolean hasAmmoToConsume() {
        if (!this.isReloadingNeedConsumeAmmo()) {
            return true;
        }
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.getDummyAmmoAmount(this.itemStack) > 0;
        }
        return this.shooter.tacz$getItemHandler(null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                class_1799 checkAmmoStack = cap.getStackInSlot(i);
                class_1792 patt0$temp = checkAmmoStack.method_7909();
                if (patt0$temp instanceof IAmmo && (iAmmo = (IAmmo)patt0$temp).isAmmoOfGun(this.itemStack, checkAmmoStack)) {
                    return true;
                }
                class_1792 patt1$temp = checkAmmoStack.method_7909();
                if (!(patt1$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt1$temp).isAmmoBoxOfGun(this.itemStack, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public int putAmmoInMagazine(int amount) {
        int currentAmmoCount;
        int newAmmoCount;
        if (amount < 0) {
            return 0;
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        if (maxAmmoCount < (newAmmoCount = (currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack)) + amount)) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, maxAmmoCount);
            return newAmmoCount - maxAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, newAmmoCount);
        return 0;
    }

    public int removeAmmoFromMagazine(int amount) {
        if (amount < 0) {
            return 0;
        }
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        if (currentAmmoCount < amount) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, 0);
            return currentAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, currentAmmoCount - amount);
        return amount;
    }

    public int getAmmoCountInMagazine() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public boolean hasAmmoInBarrel() {
        Bolt boltType = this.gunIndex.getGunData().getBolt();
        return boltType != Bolt.OPEN_BOLT && this.abstractGunItem.hasBulletInBarrel(this.itemStack);
    }

    public void setAmmoInBarrel(boolean ammoInBarrel) {
        this.abstractGunItem.setBulletInBarrel(this.itemStack, ammoInBarrel);
    }

    public void cacheScriptData(LuaValue luaValue) {
        this.dataHolder.scriptData = luaValue;
    }

    public LuaValue getCachedScriptData() {
        return this.dataHolder.scriptData;
    }

    public LuaTable getScriptParams() {
        LuaTable param = this.gunIndex.getScriptParam();
        return param == null ? new LuaTable() : param;
    }

    public void safeAsyncTask(LuaValue value, long delayMs, long periodMs, int cycles) {
        LuaFunction func = value.checkfunction();
        CycleTaskHelper.addCycleTask(() -> func.call().checkboolean(), delayMs, periodMs, cycles);
    }

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public String getAttachment(String type) {
        try {
            AttachmentType t = AttachmentType.valueOf(type);
            return this.abstractGunItem.getAttachmentId(this.itemStack, t).toString();
        }
        catch (IllegalArgumentException e) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID.toString();
        }
    }

    public LuaNbtAccessor getNbt() {
        return this.nbtUtil;
    }

    public LuaEntityAccessor getEntityUtil() {
        if (this.entityAccessor == null) {
            this.entityAccessor = new LuaEntityAccessor(this.shooter);
        }
        return this.entityAccessor;
    }

    public void setShooter(class_1309 shooter) {
        this.shooter = shooter;
    }

    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.initGunItem();
    }

    public void setPitchSupplier(Supplier<Float> pitchSupplier) {
        this.pitchSupplier = pitchSupplier;
    }

    public void setYawSupplier(Supplier<Float> yawSupplier) {
        this.yawSupplier = yawSupplier;
    }

    public class_1309 getShooter() {
        return this.shooter;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public AbstractGunItem getAbstractGunItem() {
        return this.abstractGunItem;
    }

    public CommonGunIndex getGunIndex() {
        return this.gunIndex;
    }

    public void setHeatAmount(float amount) {
        this.abstractGunItem.setHeatAmount(this.itemStack, amount);
    }

    public float getHeatAmount() {
        return this.abstractGunItem.getHeatAmount(this.itemStack);
    }

    public boolean hasHeatData() {
        return this.gunIndex.getGunData().getHeatData() != null;
    }

    public float getHeatMinRpm() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMinRpmMod();
        }
        return 0.0f;
    }

    public float getHeatMaxRpm() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMaxRpmMod();
        }
        return 0.0f;
    }

    public float getHeatMinInaccuracy() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMinInaccuracy();
        }
        return 0.0f;
    }

    public float getHeatMaxInaccuracy() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMaxInaccuracy();
        }
        return 0.0f;
    }

    public float getHeatMax() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getHeatMax();
        }
        return 0.0f;
    }

    public float getHeatPerShot() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getHeatPerShot();
        }
        return 0.0f;
    }

    public boolean isOverheatLocked() {
        return this.abstractGunItem.isOverheatLocked(this.itemStack);
    }

    public void setOverheatLocked(boolean locked) {
        this.abstractGunItem.setOverheatLocked(this.itemStack, locked);
    }

    public long getOverheatTime() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getOverHeatTime();
        }
        return 0L;
    }

    public long getCoolingDelay() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getCoolingDelay();
        }
        return 0L;
    }

    public float calcHeatReduction(long heatTimestamp) {
        GunHeatData heatData = this.gunIndex.getGunData().getHeatData();
        if (heatData != null) {
            return (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
        }
        return 0.0f;
    }

    public int getBoltByInt() {
        Bolt bolt = this.gunIndex.getGunData().getBolt();
        if (bolt == Bolt.MANUAL_ACTION) {
            return 1;
        }
        if (bolt == Bolt.CLOSED_BOLT) {
            return 2;
        }
        if (bolt == Bolt.OPEN_BOLT) {
            return 3;
        }
        return 0;
    }

    public Bolt getBolt() {
        return this.gunIndex.getGunData().getBolt();
    }

    public void setDataHolder(ShooterDataHolder dataHolder) {
        this.dataHolder = dataHolder;
    }

    public boolean useInventoryAmmo() {
        return this.abstractGunItem.useInventoryAmmo(this.itemStack);
    }

    ShooterDataHolder getDataHolder() {
        return this.dataHolder;
    }

    private void initGunItem() {
        class_1792 class_17922;
        if (this.itemStack == null || !((class_17922 = this.itemStack.method_7909()) instanceof AbstractGunItem)) {
            this.gunIndex = null;
            this.abstractGunItem = null;
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)class_17922;
        this.gunId = gunItem.getGunId(this.itemStack);
        this.gunDisplayId = gunItem.getGunDisplayId(this.itemStack);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(this.gunId);
        this.gunIndex = gunIndexOptional.orElse(null);
        this.abstractGunItem = gunItem;
        if (this.itemStack.method_57826(class_9334.field_49628)) {
            this.nbtUtil = new LuaNbtAccessor(((class_9279)this.itemStack.method_57824(class_9334.field_49628)).method_57461());
        }
    }

    private LuaFunction checkFunction(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return (LuaFunction)luaValue;
        }
        if (luaValue.isnil()) {
            return null;
        }
        throw new LuaError("bad argument: function or nil expected, got " + luaValue.typename());
    }
}

