/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message.handshake;

import com.tacz.guns.GunMod;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import com.tacz.guns.network.IHandshakeMessage;
import com.tacz.guns.network.message.handshake.AcknowledgeC2SPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SyncedEntityDataMappingS2CPacket
implements IHandshakeMessage {
    public static final class_8710.class_9154<SyncedEntityDataMappingS2CPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"tacz", (String)"server_synced_entity_data_mapping"));
    public static final class_9139<class_2540, SyncedEntityDataMappingS2CPacket> STREAM_CODEC = class_9139.method_56437(SyncedEntityDataMappingS2CPacket::encode, SyncedEntityDataMappingS2CPacket::decode);
    private static final Marker HANDSHAKE = MarkerFactory.getMarker((String)"TACZ_HANDSHAKE");
    private Map<class_2960, List<Pair<class_2960, Integer>>> keyMap;

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public SyncedEntityDataMappingS2CPacket() {
        this.keyMap = new HashMap<class_2960, List<Pair<class_2960, Integer>>>();
    }

    private SyncedEntityDataMappingS2CPacket(Map<class_2960, List<Pair<class_2960, Integer>>> keyMap) {
        this.keyMap = keyMap;
    }

    public static void encode(class_2540 buffer, SyncedEntityDataMappingS2CPacket message) {
        Set<SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getKeys();
        buffer.method_53002(keys.size());
        keys.forEach(key -> {
            int id = SyncedEntityData.instance().getInternalId((SyncedDataKey<?, ?>)key);
            buffer.method_10812(key.classKey().id());
            buffer.method_10812(key.id());
            buffer.method_10804(id);
        });
    }

    public static SyncedEntityDataMappingS2CPacket decode(class_2540 buffer) {
        int size = buffer.readInt();
        HashMap<class_2960, List<Pair<class_2960, Integer>>> keyMap = new HashMap<class_2960, List<Pair<class_2960, Integer>>>();
        for (int i = 0; i < size; ++i) {
            class_2960 classId = buffer.method_10810();
            class_2960 keyId = buffer.method_10810();
            int id = buffer.method_10816();
            keyMap.computeIfAbsent(classId, c -> new ArrayList()).add(Pair.of((Object)keyId, (Object)id));
        }
        return new SyncedEntityDataMappingS2CPacket(keyMap);
    }

    @Override
    public void handle(ClientConfigurationNetworking.Context context) {
        GunMod.LOGGER.debug(HANDSHAKE, "Received synced key mappings from server");
        CountDownLatch block = new CountDownLatch(1);
        context.client().execute(() -> {
            if (!SyncedEntityData.instance().updateMappings(this.keyMap)) {
                context.responseSender().disconnect((class_2561)class_2561.method_43470((String)"Connection closed - [TacZ] Received unknown synced data keys."));
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.responseSender().sendPacket((class_8710)AcknowledgeC2SPacket.INSTANCE);
    }
}

