/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RecipeFilterManager
extends class_4080<Map<class_2960, List<JsonElement>>>
implements INetworkCacheReloadListener {
    private final Map<class_2960, RecipeFilter> filters = Maps.newHashMap();
    private final Gson gson = CommonAssetsManager.GSON;
    private final Marker marker = MarkerFactory.getMarker((String)"RecipeFilter");
    private final class_7654 fileToIdConverter = class_7654.method_45114((String)"recipe_filters");
    protected Map<class_2960, String> networkCache;
    public static final class_2960 ID = class_2960.method_60655((String)"tacz", (String)"recipe_filter_manager");

    @NotNull
    protected Map<class_2960, List<JsonElement>> prepare(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<class_2960, List<JsonElement>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        this.filters.clear();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, List<JsonElement>> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();
            for (JsonElement element : entry.getValue()) {
                try {
                    RecipeFilter data = this.parseJson(element);
                    this.filters.compute(id, (key, value) -> {
                        if (value == null) {
                            return data;
                        }
                        value.merge(data);
                        return value;
                    });
                }
                catch (JsonParseException | IllegalArgumentException e) {
                    GunMod.LOGGER.error(this.marker, "Failed to load data file {}", (Object)id, (Object)e);
                }
            }
            if (!this.filters.containsKey(id)) continue;
            builder.put((Object)id, (Object)this.gson.toJson((Object)this.filters.get(id)));
        }
        this.networkCache = builder.build();
    }

    private RecipeFilter parseJson(JsonElement element) {
        return (RecipeFilter)this.gson.fromJson(element, RecipeFilter.class);
    }

    @Override
    public Map<class_2960, String> getNetworkCache() {
        return this.networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.RECIPE_FILTER;
    }

    public Map<class_2960, RecipeFilter> getFilters() {
        return this.filters;
    }

    public RecipeFilter getFilter(class_2960 id) {
        return this.filters.get(id);
    }

    public class_2960 getFabricId() {
        return ID;
    }
}

