/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class EffectiveRangeModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.EFFECTIVE_RANGE.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new EffectiveRangeJsonProperty(data.getEffectiveRange());
    }

    @Override
    public CacheValue<Float> initCache(class_1799 gunItem, GunData gunData) {
        LinkedList<ExtraDamage.DistanceDamagePair> damageAdjust = null;
        if (gunData.getBulletData().getExtraDamage() != null) {
            damageAdjust = gunData.getBulletData().getExtraDamage().getDamageAdjust();
        }
        float effectiveRange = damageAdjust != null ? damageAdjust.get(0).getDistance() : 2.1474836E9f;
        return new CacheValue<Float>(Float.valueOf(effectiveRange));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float modifiedDistance = ((Float)cacheProperty.getCache(ID)).floatValue();
        LinkedList<ExtraDamage.DistanceDamagePair> damageAdjust = null;
        if (gunData.getBulletData().getExtraDamage() != null) {
            damageAdjust = gunData.getBulletData().getExtraDamage().getDamageAdjust();
        }
        float effectiveRange = damageAdjust != null ? damageAdjust.get(0).getDistance() : 0.0f;
        modifiedDistance = Math.min(modifiedDistance, 1024.0f);
        effectiveRange = Math.min(effectiveRange, 1024.0f);
        float modifier = modifiedDistance - effectiveRange;
        double percent = Math.min((double)effectiveRange / 100.0, 1.0);
        double modifierPercent = Math.min((double)modifier / 100.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.effective_range";
        String positivelyString = String.format("%.1fm \u00a7a(+%.1f)", Float.valueOf(effectiveRange), Float.valueOf(modifier));
        String negativelyString = String.format("%.1fm \u00a7c(%.1f)", Float.valueOf(effectiveRange), Float.valueOf(modifier));
        String defaultString = String.format("%.1fm", Float.valueOf(effectiveRange));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="effective_range")
        @Nullable
        private Modifier effectiveRange = null;

        @Nullable
        public Modifier getEffectiveRange() {
            return this.effectiveRange;
        }
    }

    public static class EffectiveRangeJsonProperty
    extends JsonProperty<Modifier> {
        public EffectiveRangeJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 25.0);
                if (eval > 25.0) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.effective_range.increase").method_27692(class_124.field_1060));
                } else if (eval < 25.0) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.effective_range.decrease").method_27692(class_124.field_1061));
                }
            }
        }
    }
}

