/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class WeightModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.WEIGHT.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        Modifier weightModifier = data.getWeightModifier();
        if (weightModifier == null) {
            weightModifier = new Modifier();
            weightModifier.setAddend(data.getWeightAddend());
        }
        return new WeightJsonProperty(weightModifier);
    }

    @Override
    public CacheValue<Float> initCache(class_1799 gunItem, GunData gunData) {
        return new CacheValue<Float>(Float.valueOf(gunData.getWeight()));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    public String getOptionalFields() {
        return "weight";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float weight = gunData.getWeight();
        float modifiedValue = ((Float)cacheProperty.getCache(ID)).floatValue();
        float modifier = modifiedValue - weight;
        double percent = Math.min((double)weight / 20.0, 1.0);
        double modifierPercent = Math.min((double)modifier / 20.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.weight";
        String positivelyString = String.format("%.2fkg \u00a7c(+%.2f)", Float.valueOf(modifiedValue), Float.valueOf(modifier));
        String negativelyString = String.format("%.2fkg \u00a7a(%.2f)", Float.valueOf(modifiedValue), Float.valueOf(modifier));
        String defaultString = String.format("%.2fkg", Float.valueOf(modifiedValue));
        boolean positivelyBetter = false;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @Nullable
        @SerializedName(value="weight_modifier")
        private Modifier weightModifier;
        @SerializedName(value="weight")
        @Deprecated
        private float weightAddend = 0.0f;

        @Nullable
        public Modifier getWeightModifier() {
            return this.weightModifier;
        }

        @Deprecated
        public float getWeightAddend() {
            return this.weightAddend;
        }
    }

    public static class WeightJsonProperty
    extends JsonProperty<Modifier> {
        public WeightJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            float adsAddendTime = 0.0f;
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 0.2);
                adsAddendTime = (float)(eval - 0.2);
            }
            if (adsAddendTime > 0.0f) {
                this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.weight.increase").method_27692(class_124.field_1061));
            } else if (adsAddendTime < 0.0f) {
                this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.weight.decrease").method_27692(class_124.field_1060));
            }
        }
    }
}

