/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.pojo.data.gun;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import javax.annotation.Nullable;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class GunRecoil {
    private static final SplineInterpolator INTERPOLATOR = new SplineInterpolator();
    @SerializedName(value="pitch")
    @Nullable
    private GunRecoilKeyFrame[] pitch;
    @SerializedName(value="yaw")
    @Nullable
    private GunRecoilKeyFrame[] yaw;

    public GunRecoilKeyFrame[] getPitch() {
        return this.pitch;
    }

    public void setPitch(@Nullable GunRecoilKeyFrame[] pitch) {
        this.pitch = pitch;
    }

    public GunRecoilKeyFrame[] getYaw() {
        return this.yaw;
    }

    public void setYaw(@Nullable GunRecoilKeyFrame[] yaw) {
        this.yaw = yaw;
    }

    @Nullable
    public PolynomialSplineFunction genPitchSplineFunction(float modifier) {
        return this.getSplineFunction(this.pitch, modifier);
    }

    @Nullable
    public PolynomialSplineFunction genYawSplineFunction(float modifier) {
        return this.getSplineFunction(this.yaw, modifier);
    }

    private PolynomialSplineFunction getSplineFunction(GunRecoilKeyFrame[] keyFrames, float modifier) {
        int i;
        if (keyFrames == null || keyFrames.length == 0) {
            return null;
        }
        double[] values = new double[keyFrames.length + 1];
        double[] times = new double[keyFrames.length + 1];
        times[0] = 0.0;
        values[0] = 0.0;
        for (i = 0; i < keyFrames.length; ++i) {
            times[i + 1] = keyFrames[i].getTime() * 1000.0f + 30.0f;
        }
        for (i = 0; i < keyFrames.length; ++i) {
            float[] value = keyFrames[i].getValue();
            values[i + 1] = ((double)value[0] + Math.random() * (double)(value[1] - value[0])) * (double)modifier;
        }
        return INTERPOLATOR.interpolate(times, values);
    }
}

