package com.tacz.guns.api.item.attachment;

import com.google.gson.annotations.SerializedName;
import com.mojang.serialization.Codec;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum AttachmentType implements class_3542 {
    /**
     * 瞄具
     */
    @SerializedName("scope")
    SCOPE,
    /**
     * 枪口组件
     */
    @SerializedName("muzzle")
    MUZZLE,
    /**
     * 枪托
     */
    @SerializedName("stock")
    STOCK,
    /**
     * 握把
     */
    @SerializedName("grip")
    GRIP,
    /**
     * 激光指示器
     */
    @SerializedName("laser")
    LASER,
    /**
     * 扩容弹夹（匣）
     */
    @SerializedName("extended_mag")
    EXTENDED_MAG,
    /**
     * 用来表示物品不是配件的情况。
     */
    NONE;

    public static final Codec<AttachmentType> CODEC = class_3542.method_28140(AttachmentType::values);

    @Override
    public @NotNull String method_15434() {
        return name();
    }

    public static AttachmentType fromId(int id) {
        return VALUES[id];
    }

    private static final AttachmentType[] VALUES = AttachmentType.values();
}