package com.tacz.guns.util;

import com.tacz.guns.config.util.HeadShotAABBConfigRead;
import com.tacz.guns.entity.EntityKineticBullet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EntityUtil {
    private static final Predicate<class_1297> PROJECTILE_TARGETS = input -> input != null && input.method_5863() && !input.method_7325();

    @Nullable
    public static EntityKineticBullet.EntityResult findEntityOnPath(class_1676 bulletEntity, class_243 startVec, class_243 endVec) {

        class_243 hitVec = null;
        class_1297 hitEntity = null;
        boolean headshot = false;
        // 获取子弹 tick 路径上所有的实体
        List<class_1297> entities = bulletEntity.method_37908().method_8333(bulletEntity, bulletEntity.method_5829().method_18804(bulletEntity.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        class_1297 owner = bulletEntity.method_24921();
        for (class_1297 entity : entities) {
            // 禁止对自己造成伤害（如有需要可以增加 Config 开启对自己的伤害）
            if (!entity.equals(owner)) {
                // 射击无视自己的载具和该载具上的其他乘客
                if (owner != null && entity.method_5794(owner)) {
                    continue;
                }
                EntityKineticBullet.EntityResult result = getHitResult(bulletEntity, entity, startVec, endVec);
                if (result == null) {
                    continue;
                }
                class_243 hitPos = result.getHitPos();
                double distanceToHit = startVec.method_1022(hitPos);
                if (entity.method_5805()) {
                    if (distanceToHit < closestDistance) {
                        hitVec = hitPos;
                        hitEntity = entity;
                        closestDistance = distanceToHit;
                        headshot = result.isHeadshot();
                    }
                }
            }
        }
        return hitEntity != null ? new EntityKineticBullet.EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @NotNull
    public static List<EntityKineticBullet.EntityResult> findEntitiesOnPath(class_1676 bulletEntity, class_243 startVec, class_243 endVec) {
        List<EntityKineticBullet.EntityResult> hitEntities = new ArrayList<>();
        List<class_1297> entities = bulletEntity.method_37908().method_8333(bulletEntity, bulletEntity.method_5829().method_18804(bulletEntity.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        class_1297 owner = bulletEntity.method_24921();
        for (class_1297 entity : entities) {
            if (!entity.equals(owner)) {
                if (owner != null && entity.equals(owner.method_5854())) {
                    continue;
                }
                EntityKineticBullet.EntityResult result = getHitResult(bulletEntity, entity, startVec, endVec);
                if (result == null) {
                    continue;
                }
                if (entity.method_5805()) {
                    hitEntities.add(result);
                }
            }
        }
        return hitEntities;
    }

    @Nullable
    protected static EntityKineticBullet.EntityResult getHitResult(class_1676 bulletEntity, class_1297 entity, class_243 startVec, class_243 endVec) {
        class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, bulletEntity.method_24921());
        // 计算射线与实体 boundingBox 的交点
        class_243 hitPos = boundingBox.method_992(startVec, endVec).orElse(null);
        // 爆头判定
        if (hitPos == null) {
            return null;
        }
        class_243 hitBoxPos = hitPos.method_1020(entity.method_19538());
        class_2960 entityId = class_7923.field_41177.method_10221(entity.method_5864());
        // 有配置的调用配置
        if (entityId != null) {
            class_238 aabb = HeadShotAABBConfigRead.getAABB(entityId);
            if (aabb != null) {
                return new EntityKineticBullet.EntityResult(entity, hitPos, aabb.method_1006(hitBoxPos));
            }
        }
        // 没有配置的默认给一个
        boolean headshot = false;
        float eyeHeight = entity.method_5751();
        if ((eyeHeight - 0.25) < hitBoxPos.field_1351 && hitBoxPos.field_1351 < (eyeHeight + 0.25)) {
            headshot = true;
        }
        return new EntityKineticBullet.EntityResult(entity, hitPos, headshot);
    }
}
