package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Objects;

public interface AmmoItemDataAccessor extends IAmmo {
    String AMMO_ID_TAG = "AmmoId";

    @Override
    @Nonnull
    default class_2960 getAmmoId(class_1799 ammo) {
        class_2487 nbt = ammo.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(AMMO_ID_TAG, class_2520.field_33258)) {
            class_2960 gunId = class_2960.method_12829(nbt.method_10558(AMMO_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_AMMO_ID);
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default void setAmmoId(class_1799 ammo, @Nullable class_2960 ammoId) {
        ammo.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            if (ammoId != null) {
                tag.method_10582(AMMO_ID_TAG, ammoId.toString());
                if (ammo.method_7909() instanceof IAmmo) {
                    int maxStackSize = TimelessAPI.getCommonAmmoIndex(ammoId).map(CommonAmmoIndex::getStackSize).orElse(1);
                    ammo.method_57379(class_9334.field_50071, maxStackSize);
                }
                return;
            }
            tag.method_10582(AMMO_ID_TAG, DefaultAssets.DEFAULT_AMMO_ID.toString());
        }));
    }

    @Override
    default boolean isAmmoOfGun(class_1799 gun, class_1799 ammo) {
        if (gun.method_7909() instanceof IGun iGun && ammo.method_7909() instanceof IAmmo iAmmo) {
            class_2960 gunId = iGun.getGunId(gun);
            class_2960 ammoId = iAmmo.getAmmoId(ammo);
            return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals(ammoId)).orElse(false);
        }
        return false;
    }
}