package com.tacz.guns.block;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.MapCodec;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModBlocks;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.properties.*;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public class TargetBlock extends class_2237 {
    public static final MapCodec<TargetBlock> field_46280 = method_54094((properties) -> new TargetBlock());
    public static final class_2758 OUTPUT_POWER = class_2741.field_12511;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 STAND = class_2746.method_11825("stand");
    public static final class_265 BOX_BOTTOM_STAND_X = class_259.method_1084(class_2248.method_9541(6, 0, 6, 10, 16, 10), class_2248.method_9541(6, 13, 2, 10, 16, 14));
    public static final class_265 BOX_BOTTOM_STAND_Z = class_259.method_1084(class_2248.method_9541(6, 0, 6, 10, 16, 10), class_2248.method_9541(2, 13, 6, 14, 16, 10));
    public static final class_265 BOX_BOTTOM_DOWN = class_2248.method_9541(6, 0, 6, 10, 4, 10);
    public static final class_265 BOX_UPPER_X = class_2248.method_9541(6, 0, 2, 10, 16, 14);
    public static final class_265 BOX_UPPER_Z = class_2248.method_9541(2, 0, 6, 14, 16, 10);

    public TargetBlock() {
        super(class_2251.method_9637().method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_22488().method_50012(class_3619.field_15971));
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(HALF, class_2756.field_12607).method_11657(STAND, true).method_11657(OUTPUT_POWER, 0));
    }

    @Override
    protected MapCodec<TargetBlock> method_53969() {
        return field_46280;
    }

    public static int getRedstoneStrength(class_3965 hit, boolean isUpperBlock) {
        // 击中下方，恒为 1
        if (!isUpperBlock) {
            return 1;
        }
        class_243 hitLocation = hit.method_17784();
        class_2350 direction = hit.method_17780();
        // 标靶中心为 (0.5, 0.32, 0.5)
        double x = Math.abs(class_3532.method_15385(hitLocation.field_1352) - 0.5);
        double y = Math.abs(class_3532.method_15385(hitLocation.field_1351) - 0.32);
        double z = Math.abs(class_3532.method_15385(hitLocation.field_1350) - 0.5);
        class_2350.class_2351 axis = direction.method_10166();
        double distance;
        if (axis == class_2350.class_2351.field_11052) {
            distance = Math.max(x, z);
        } else if (axis == class_2350.class_2351.field_11051) {
            distance = Math.max(x, y);
        } else {
            distance = Math.max(y, z);
        }
        // 离开中心 0.25 单位就是最低分？
        double percent = class_3532.method_15350((0.25 - distance) / 0.25, 0, 1);
        return Math.max(1, class_3532.method_15384(15 * percent));
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return state.method_11654(HALF).equals(class_2756.field_12607) && level.method_8608() ? method_31618(blockEntityType, ModBlocks.TARGET_BE, TargetBlockEntity::clientTick) : null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, HALF, STAND, OUTPUT_POWER);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 blockState) {
        if (blockState.method_11654(HALF).equals(class_2756.field_12607)) {
            return new TargetBlockEntity(pos, blockState);
        } else {
            return null;
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        boolean stand = state.method_11654(STAND);
        boolean axis = state.method_11654(FACING).method_10166().equals(class_2350.class_2351.field_11048);
        if (state.method_11654(HALF).equals(class_2756.field_12609)) {
            return stand ? (axis ? BOX_UPPER_X : BOX_UPPER_Z) : class_259.method_1073();
        }
        return stand ? (axis ? BOX_BOTTOM_STAND_X : BOX_BOTTOM_STAND_Z) : BOX_BOTTOM_DOWN;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        // 计划刻的内容
        if (!state.method_11654(STAND)) {
            level.method_8652(pos, state.method_11657(STAND, true).method_11657(OUTPUT_POWER, 0), class_2248.field_31036);
        }
    }

    @Override
    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (hit.method_17780().method_10153().equals(state.method_11654(FACING))) {
            if (state.method_11654(HALF).equals(class_2756.field_12607)) {
                world.method_35230(hit.method_17777(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, false));
            } else if (state.method_11654(HALF).equals(class_2756.field_12609)) {
                world.method_35230(hit.method_17777().method_10074(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, true));
            }

            if (!world.method_8608() && projectile.method_24921() instanceof class_1657 player && state.method_11654(STAND)) {
                if (projectile instanceof EntityKineticBullet bullet) {
                    String formattedDamage = String.format("%.1f", bullet.getDamage(hit.method_17784()));
                    String formattedDistance = String.format("%.2f", hit.method_17784().method_1022(player.method_19538()));
                    player.method_7353(class_2561.method_43469("message.tacz.target_minecart.hit", formattedDamage, formattedDistance), true);
                }

            }
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2756 half = state.method_11654(HALF);
        boolean stand = state.method_11654(STAND);

        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            if (half.equals(class_2756.field_12607) && facing == class_2350.field_11036 || half.equals(class_2756.field_12609) && facing == class_2350.field_11033) {
                // 拆一半另外一半跟着没
                if (!facingState.method_27852(this)) {
                    return class_2246.field_10124.method_9564();
                }
                // 同步击倒状态
                if (facingState.method_11654(STAND) != stand) {
                    return state.method_11657(STAND, facingState.method_11654(STAND)).method_11657(OUTPUT_POWER, facingState.method_11654(OUTPUT_POWER));
                }
            }
        }

        // 底下方块没了也拆掉
        if (half == class_2756.field_12607 && facing == class_2350.field_11033 && !state.method_26184(level, currentPos)) {
            return class_2246.field_10124.method_9564();
        } else {
            return state;
        }
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042();
        class_2338 clickedPos = context.method_8037();
        class_2338 above = clickedPos.method_10084();
        class_1937 level = context.method_8045();
        if (level.method_8320(above).method_26166(context) && level.method_8621().method_11952(above)) {
            return this.method_9564().method_11657(FACING, direction);
        }
        return null;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            class_2338 above = pos.method_10084();
            world.method_8652(above, state.method_11657(HALF, class_2756.field_12609), class_2248.field_31036);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101(world, pos, class_2248.field_31036);
            if (stack.method_57826(class_9334.field_49631)) {
                class_2586 blockentity = world.method_8321(pos);
                if (blockentity instanceof TargetBlockEntity e) {
                    class_9296 profile = new class_9296(Optional.of(stack.method_7964().getString()), Optional.empty(), new PropertyMap());
                    e.setOwner(profile);
                    e.setCustomName(stack.method_7964());
                    e.refresh();
                }
            }
        }
    }

    @Override
    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        class_2338 blockPos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        class_2586 blockentity = level.method_8321(blockPos);
        if (blockentity instanceof TargetBlockEntity e) {
            class_1799 stack = new class_1799(this);
            stack.method_57379(class_9334.field_49631, e.method_5797());
            return stack;
        }
        return super.method_9574(level, pos, state);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = level.method_8320(blockpos);
        if (state.method_11654(HALF) == class_2756.field_12607) {
            return true;
        }
        return blockstate.method_27852(this);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        return blockState.method_11654(OUTPUT_POWER);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!level.method_8608() && !state.method_27852(oldState.method_26204())) {
            if (state.method_11654(OUTPUT_POWER) > 0 && !level.method_8397().method_8674(pos, this)) {
                level.method_8652(pos, state.method_11657(OUTPUT_POWER, 0), class_2248.field_31031 | class_2248.field_31028);
            }
        }
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
}
