package com.tacz.guns.client.model.functional;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.ShellEjection;
import com.tacz.guns.compat.iris.IrisCompat;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class ShellRender implements IFunctionalRenderer {
    // 抛壳队列
    private final ConcurrentLinkedDeque<Data> SHELL_QUEUE = new ConcurrentLinkedDeque<>();
    public static boolean isSelf = false;

    private final BedrockGunModel bedrockGunModel;

    public ShellRender(BedrockGunModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    public void addShell(Vector3f randomVelocity) {
        if (SHELL_QUEUE.size() > 128) {
            SHELL_QUEUE.pollFirst();
        }
        double xRandom = Math.random() * randomVelocity.x();
        double yRandom = Math.random() * randomVelocity.y();
        double zRandom = Math.random() * randomVelocity.z();
        Vector3f vector3f = new Vector3f((float) xRandom, (float) yRandom, (float) zRandom);
        SHELL_QUEUE.offerLast(new Data(System.currentTimeMillis(), vector3f));
    }

    private void renderShell(GunDisplayInstance display, GunData gunData, class_4587 poseStack, BedrockGunModel gunModel) {
        ShellEjection shellEjection = display.getShellEjection();
        if (shellEjection == null) {
            SHELL_QUEUE.clear();
            return;
        }
        TimelessAPI.getClientAmmoIndex(gunData.getAmmoId()).ifPresent(ammoIndex -> {
            BedrockAmmoModel model = ammoIndex.getShellModel();
            if (model == null) {
                return;
            }
            class_2960 location = ammoIndex.getShellTextureLocation();
            if (location == null) {
                return;
            }
            long lifeTime = (long) (shellEjection.getLivingTime() * 1000);

            // 检查有没有需要踢出去的队列
            checkShellQueue(lifeTime);

            // 各种参数的获取
            Vector3f initialVelocity = shellEjection.getInitialVelocity();
            Vector3f acceleration = shellEjection.getAcceleration();
            Vector3f angularVelocity = shellEjection.getAngularVelocity();

            // 缓存一下 PoseStack
            for (Data data : SHELL_QUEUE) {
                if (data.normal == null && data.pose == null) {
                    data.normal = new Matrix3f(poseStack.method_23760().method_23762());
                    data.pose = new Matrix4f(poseStack.method_23760().method_23761());
                }
            }

            // 渲染抛壳
            gunModel.delegateRender((poseStack1, vertexConsumer1, transformType1, light, overlay) ->{
                SHELL_QUEUE.forEach(data -> renderSingleShell(transformType1, light, overlay, data, initialVelocity, acceleration, angularVelocity, model, location));
            });
        });
    }

    private void renderSingleShell(class_811 transformType1, int light, int overlay, Data data, Vector3f initialVelocity, Vector3f acceleration, Vector3f angularVelocity, BedrockAmmoModel model, class_2960 location) {
        // 再检查一次
        if (data.normal == null && data.pose == null) {
            return;
        }
        // 先初始化到缓存位置和朝向
        class_4587 poseStack2 = new class_4587();
        poseStack2.method_23760().method_23762().mul(data.normal);
        poseStack2.method_23760().method_23761().mul(data.pose);

        // 获取存留时间和各种参数
        long remindTime = System.currentTimeMillis() - data.timeStamp;
        double time = remindTime / 1000.0;
        Vector3f randomOffset = data.randomOffset;

        // 位移，满足标准的匀变速直线运动
        double x = (initialVelocity.x() + randomOffset.x()) * time + 0.5 * acceleration.x() * time * time;
        double y = (initialVelocity.y() + randomOffset.y()) * time + 0.5 * acceleration.y() * time * time;
        double z = (initialVelocity.z() + randomOffset.z()) * time + 0.5 * acceleration.z() * time * time;
        poseStack2.method_22904(-x, -y, z);

        // 旋转
        double xw = time * angularVelocity.x();
        double yw = time * angularVelocity.y();
        double zw = time * angularVelocity.z();
        poseStack2.method_22907(class_7833.field_40713.rotationDegrees((float) xw));
        poseStack2.method_22907(class_7833.field_40715.rotationDegrees((float) yw));
        poseStack2.method_22907(class_7833.field_40718.rotationDegrees((float) zw));
        poseStack2.method_22904(0, -1.5, 0);

        model.render(poseStack2, transformType1, class_1921.method_23576(location), light, overlay);
    }

    private void checkShellQueue(long lifeTime) {
        if (!SHELL_QUEUE.isEmpty()) {
            Data data = SHELL_QUEUE.peekFirst();
            if ((System.currentTimeMillis() - data.timeStamp) > lifeTime) {
                SHELL_QUEUE.pollFirst();
                checkShellQueue(lifeTime);
            }
        }
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexBuffer, class_811 transformType, int light, int overlay) {
        if (IrisCompat.isRenderShadow()) {
            return;
        }
        if (!isSelf) {
            return;
        }
        class_1799 currentGunItem = bedrockGunModel.getCurrentGunItem();
        IGun iGun = IGun.getIGunOrNull(currentGunItem);
        if (iGun == null) {
            return;
        }
        GunData gunData = TimelessAPI.getClientGunIndex(iGun.getGunId(currentGunItem)).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(currentGunItem).ifPresent(display -> {
            this.renderShell(display, gunData, poseStack, bedrockGunModel);
        });

    }

    public static class Data {
        public final long timeStamp;
        public final Vector3f randomOffset;

        public Matrix3f normal = null;
        public Matrix4f pose = null;

        public Data(long timeStamp, Vector3f randomOffset) {
            this.timeStamp = timeStamp;
            this.randomOffset = randomOffset;
        }
    }
}
