package com.tacz.guns.client.model.functional;

import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.papi.PapiManager;
import com.tacz.guns.client.resource.pojo.display.gun.TextShow;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TextShowRender implements IFunctionalRenderer {
    private final BedrockModel bedrockModel;
    private final TextShow textShow;
    private final class_1799 gunStack;

    public TextShowRender(BedrockModel bedrockModel, TextShow textShow, class_1799 gunStack) {
        this.bedrockModel = bedrockModel;
        this.textShow = textShow;
        this.gunStack = gunStack;
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexBuffer, class_811 transformType, int light, int overlay) {
        if (!transformType.method_29998()) {
            return;
        }
        String text = PapiManager.getTextShow(textShow.getTextKey(), gunStack);
        if (StringUtils.isBlank(text)) {
            return;
        }
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
        Matrix3f normal = new Matrix3f(poseStack.method_23760().method_23762());
        Matrix4f pose = new Matrix4f(poseStack.method_23760().method_23761());

        // 和枪械模型共用顶点缓冲的都需要代理到渲染结束后渲染
        bedrockModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
            class_327 font = class_310.method_1551().field_1772;
            boolean shadow = textShow.isShadow();
            int color = textShow.getColorInt();
            float scale = textShow.getScale();
            int packLight = class_765.method_23687(textShow.getTextLight(), textShow.getTextLight());
            int width = font.method_1727(text);
            int xOffset;
            switch (textShow.getAlign()) {
                case CENTER -> xOffset = width / 2;
                case RIGHT -> xOffset = width;
                default -> xOffset = 0;
            }

            class_4587 poseStack2 = new class_4587();
            poseStack2.method_23760().method_23762().mul(normal);
            poseStack2.method_23760().method_23761().mul(pose);
            poseStack2.method_22905(2 / 300f * scale, -2 / 300f * scale, -2 / 300f);

            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            font.method_27521(text, -xOffset, -font.field_2000 / 2f, color, shadow, poseStack2.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, packLight);
            bufferSource.method_22993();
        });
    }
}
