package com.tacz.guns.compat.cloth.common;

import com.tacz.guns.config.PreLoadConfig;
import com.tacz.guns.config.common.OtherConfig;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;

public class OtherClothConfig {
    public static void init(ConfigBuilder root, ConfigEntryBuilder entryBuilder) {
        ConfigCategory other = root.getOrCreateCategory(class_2561.method_43471("config.tacz.common.other"));

        other.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("config.tacz.common.other.default_pack_debug"), PreLoadConfig.override.get())
                .setDefaultValue(false).setTooltip(class_2561.method_43471("config.tacz.common.other.default_pack_debug.desc"))
                .setSaveConsumer(value -> {
                    PreLoadConfig.override.set(value);
                    PreLoadConfig.override.save();
                }).build());

        other.addEntry(entryBuilder.startIntField(class_2561.method_43471("config.tacz.common.other.target_sound_distance"), OtherConfig.TARGET_SOUND_DISTANCE.get())
                .setMin(0).setMax(Integer.MAX_VALUE).setDefaultValue(128).setTooltip(class_2561.method_43471("config.tacz.common.other.target_sound_distance.desc"))
                .setSaveConsumer(value -> {
                    OtherConfig.TARGET_SOUND_DISTANCE.set(value);
                    OtherConfig.TARGET_SOUND_DISTANCE.save();
                }).build());

//        other.addEntry(entryBuilder.startBooleanToggle(Component.translatable("config.tacz.common.other.enable_table_filter"), OtherConfig.ENABLE_TABLE_FILTER.get())
//                .setDefaultValue(true).setTooltip(Component.translatable("config.tacz.common.other.enable_table_filter.desc"))
//                .setSaveConsumer(value -> {
//                    OtherConfig.ENABLE_TABLE_FILTER.set(value);
//                    OtherConfig.ENABLE_TABLE_FILTER.save();
//                }).build());
    }
}
